# LevelUpTogether

A Stardew Valley mod that synchronizes all players' skill levels to the highest level at the end of each day in multiplayer games.

## Features

- **Automatic Skill Synchronization**: At the end of each day, all players' skill levels are synchronized to match the highest level player for each skill category
- **Configurable Skills**: Choose which skills to synchronize (Farming, Mining, Foraging, Fishing, Combat, Luck)
- **Multiplayer Support**: Designed specifically for multiplayer games with proper data synchronization
- **Optional Single Player**: Can be enabled for single player games (disabled by default)
- **Visual Feedback**: Shows messages when skills are synchronized (can be disabled)

## How It Works

1. At the end of each day, the mod collects skill data from all players
2. For each skill category, it finds the player with the highest experience points
3. All other players' experience in that skill is set to match the highest player
4. Skills are synchronized across all connected players

## Example

- Player 1: Farming Level 5 (2,500 XP), Combat Level 2 (200 XP)
- Player 2: Farming Level 3 (1,000 XP), Combat Level 7 (8,000 XP)

After synchronization:
- Both players: Farming Level 5 (2,500 XP), Combat Level 7 (8,000 XP)

## Configuration

The mod supports configuration through Generic Mod Config Menu (GMCM) if installed:

- **Enable Mod**: Toggle the entire mod on/off
- **Sync [Skill]**: Toggle synchronization for specific skills
- **Enable in Single Player**: Allow the mod to work in single player games
- **Show Sync Messages**: Display messages when skills are synchronized

## Installation

1. Install the latest version of SMAPI
2. Download and extract this mod to your `Mods` folder
3. Run the game using SMAPI

## Requirements

- SMAPI 3.15.0 or later
- Stardew Valley 1.5.6 or later

## Multiplayer Notes

- Only the main player (host) processes the synchronization logic
- Skill data is automatically synchronized to all connected players
- Players can join mid-game and will be included in the next synchronization

## Compatibility

This mod should be compatible with most other mods. It only modifies player experience points and does not change core game mechanics.

## Source Code

This mod is open source. Feel free to examine, modify, or contribute to the code.