/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.predefined;

import com.wuest.prefab.Tuple;
import com.wuest.prefab.structures.base.BuildBlock;
import com.wuest.prefab.structures.base.BuildingMethods;
import com.wuest.prefab.structures.base.Structure;
import com.wuest.prefab.structures.config.BasicStructureConfiguration;
import com.wuest.prefab.structures.config.StructureConfiguration;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class StructureBasic
extends Structure {
    private final ArrayList<Tuple<BlockPos, BlockPos>> bedPositions = new ArrayList();
    private final ArrayList<BlockPos> mobSpawnerPos = new ArrayList();
    BlockPos customBlockPos = null;
    private BlockPos signPosition = null;

    @Override
    protected Boolean CustomBlockProcessingHandled(StructureConfiguration configuration, BuildBlock block, World world, BlockPos originalPos, EnumFacing assumedNorth, Block foundBlock, IBlockState blockState, EntityPlayer player) {
        BasicStructureConfiguration config = (BasicStructureConfiguration)configuration;
        BasicStructureConfiguration.EnumBasicStructureName enumName = config.basicStructureName;
        if (foundBlock instanceof BlockBed && config.chosenOption.getHasBedColor()) {
            BlockPos bedHeadPosition = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
            BlockPos bedFootPosition = block.getSubBlock().getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
            this.bedPositions.add(new Tuple<BlockPos, BlockPos>(bedHeadPosition, bedFootPosition));
            return true;
        }
        ResourceLocation blockIdentifier = foundBlock.getRegistryName();
        ResourceLocation glassIdentifier = Blocks.field_150399_cn.getRegistryName();
        ResourceLocation glassPaneIdentifier = Blocks.field_150397_co.getRegistryName();
        if (blockIdentifier.func_110624_b().equals(glassIdentifier.func_110624_b()) && blockIdentifier.func_110623_a().endsWith("glass") && config.chosenOption.getHasGlassColor()) {
            blockState = this.getStainedGlassBlock(config.glassColor);
            block.setBlockState(blockState);
            this.priorityOneBlocks.add(block);
            return true;
        }
        if (blockIdentifier.func_110624_b().equals(glassPaneIdentifier.func_110624_b()) && blockIdentifier.func_110623_a().endsWith("glass_pane") && config.chosenOption.getHasGlassColor()) {
            blockState = this.getStainedGlassPaneBlock(config.glassColor);
            BuildBlock.SetBlockState(configuration, world, originalPos, assumedNorth, block, foundBlock, blockState, this);
            this.priorityOneBlocks.add(block);
            return true;
        }
        return false;
    }

    @Override
    public void AfterBuilding(StructureConfiguration configuration, World world, BlockPos originalPos, EnumFacing assumedNorth, EntityPlayer player) {
        BasicStructureConfiguration config = (BasicStructureConfiguration)configuration;
        BasicStructureConfiguration.EnumBasicStructureName enumName = config.basicStructureName;
        if (this.customBlockPos != null) {
            this.customBlockPos = null;
        }
        if (this.bedPositions.size() > 0) {
            for (Tuple<BlockPos, BlockPos> bedPosition : this.bedPositions) {
                BuildingMethods.PlaceColoredBed(world, bedPosition.getFirst(), bedPosition.getSecond(), config.bedColor);
            }
        }
        if (config.basicStructureName.getName().equals(BasicStructureConfiguration.EnumBasicStructureName.AquaBase.getName())) {
            BlockPos airPos = originalPos.func_177981_b(4).func_177967_a(configuration.houseFacing.func_176734_d(), 1);
            world.func_175698_g(airPos.func_177972_a(configuration.houseFacing.func_176746_e()));
            world.func_175698_g(airPos);
            world.func_175698_g(airPos.func_177972_a(configuration.houseFacing.func_176735_f()));
            airPos = airPos.func_177977_b();
            world.func_175698_g(airPos.func_177972_a(configuration.houseFacing.func_176746_e()));
            world.func_175698_g(airPos);
            world.func_175698_g(airPos.func_177972_a(configuration.houseFacing.func_176735_f()));
            airPos = airPos.func_177977_b();
            world.func_175698_g(airPos.func_177972_a(configuration.houseFacing.func_176746_e()));
            world.func_175698_g(airPos);
            world.func_175698_g(airPos.func_177972_a(configuration.houseFacing.func_176735_f()));
            airPos = airPos.func_177977_b();
            world.func_175698_g(airPos.func_177972_a(configuration.houseFacing.func_176746_e()));
            world.func_175698_g(airPos);
            world.func_175698_g(airPos.func_177972_a(configuration.houseFacing.func_176735_f()));
            airPos = airPos.func_177972_a(configuration.houseFacing.func_176734_d()).func_177984_a();
            world.func_175698_g(airPos.func_177972_a(configuration.houseFacing.func_176746_e()));
            world.func_175698_g(airPos);
            world.func_175698_g(airPos.func_177972_a(configuration.houseFacing.func_176735_f()));
            airPos = airPos.func_177984_a();
            world.func_175698_g(airPos.func_177972_a(configuration.houseFacing.func_176746_e()));
            world.func_175698_g(airPos);
            world.func_175698_g(airPos.func_177972_a(configuration.houseFacing.func_176735_f()));
            airPos = airPos.func_177984_a();
            world.func_175698_g(airPos);
        }
    }
}

