/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.base;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import com.wuest.prefab.ZipUtil;
import com.wuest.prefab.blocks.FullDyeColor;
import com.wuest.prefab.proxy.CommonProxy;
import com.wuest.prefab.structures.base.BuildBlock;
import com.wuest.prefab.structures.base.BuildClear;
import com.wuest.prefab.structures.base.BuildEntity;
import com.wuest.prefab.structures.base.BuildProperty;
import com.wuest.prefab.structures.base.BuildTileEntity;
import com.wuest.prefab.structures.base.GetBlockMapping;
import com.wuest.prefab.structures.base.PositionOffset;
import com.wuest.prefab.structures.config.StructureConfiguration;
import com.wuest.prefab.structures.events.StructureEventHandler;
import com.wuest.prefab.structures.render.StructureRenderHandler2;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockBanner;
import net.minecraft.block.BlockBasePressurePlate;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.BlockCarpet;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockDeadBush;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockMushroom;
import net.minecraft.block.BlockQuartz;
import net.minecraft.block.BlockRail;
import net.minecraft.block.BlockRedstoneDiode;
import net.minecraft.block.BlockRedstoneTorch;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.BlockReed;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockSign;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.BlockVine;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLLog;

public class Structure {
    public ArrayList<BlockPos> clearedBlockPos = new ArrayList();
    public ArrayList<BuildBlock> priorityOneBlocks = new ArrayList();
    public ArrayList<BuildBlock> priorityTwoBlocks = new ArrayList();
    public ArrayList<BuildBlock> priorityThreeBlocks = new ArrayList();
    public ArrayList<BuildBlock> priorityFourBlocks = new ArrayList();
    public ArrayList<BuildBlock> priorityFiveBlocks = new ArrayList();
    public ArrayList<BuildBlock> airBlocks = new ArrayList();
    public StructureConfiguration configuration;
    public World world;
    public BlockPos originalPos;
    public EnumFacing assumedNorth;
    @Expose
    public ArrayList<BuildTileEntity> tileEntities = new ArrayList();
    @Expose
    public ArrayList<BuildEntity> entities = new ArrayList();
    @Expose
    private String name;
    @Expose
    private BuildClear clearSpace;
    @Expose
    private ArrayList<BuildBlock> blocks;
    private static final Map<String, IBlockState> blockMappingMap = new GetBlockMapping().GetBlockMapping();
    private static final Map<String, IBlockState> blockStateMapDoubleSlab = new GetBlockMapping().GetBlockStateMapDoubleSlab();

    public Structure() {
        this.Initialize();
    }

    public static <T extends Structure> T CreateInstance(String resourceLocation, Class<? extends Structure> child) {
        Structure structure = null;
        Gson file = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
        structure = (Structure)file.fromJson(ZipUtil.decompressResource(resourceLocation), child);
        return (T)structure;
    }

    public static void CreateStructureFile(Structure structure, String fileLocation) {
        try {
            Gson converter = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
            StringWriter stringWriter = new StringWriter();
            converter.toJson((Object)structure, (Appendable)stringWriter);
            ZipUtil.zipStringToFile(stringWriter.toString(), fileLocation);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void ScanStructure(World world, BlockPos originalPos, BlockPos cornerPos1, BlockPos cornerPos2, String fileLocation, BuildClear clearedSpace, EnumFacing playerFacing, boolean includeAir, boolean excludeWater) {
        Structure scannedStructure = new Structure();
        scannedStructure.setClearSpace(clearedSpace);
        for (BlockPos currentPos : BlockPos.func_177980_a((BlockPos)cornerPos1, (BlockPos)cornerPos2)) {
            if (world.func_175623_d(currentPos) && !includeAir) continue;
            IBlockState currentState = world.func_180495_p(currentPos);
            Block currentBlock = currentState.func_177230_c();
            if (currentState.func_185904_a() == Material.field_151586_h && excludeWater) continue;
            BuildBlock buildBlock = Structure.createBuildBlockFromBlockState(currentState, currentBlock, currentPos, originalPos);
            if (currentBlock instanceof BlockDoor) {
                BlockDoor.EnumDoorHalf blockHalf = (BlockDoor.EnumDoorHalf)currentState.func_177229_b((IProperty)BlockDoor.field_176523_O);
                if (blockHalf != BlockDoor.EnumDoorHalf.LOWER) continue;
                IBlockState upperHalfState = world.func_180495_p(currentPos.func_177984_a());
                if (upperHalfState != null && upperHalfState.func_177230_c() instanceof BlockDoor) {
                    Block upperBlock = upperHalfState.func_177230_c();
                    BuildBlock upperHalf = Structure.createBuildBlockFromBlockState(upperHalfState, upperBlock, currentPos.func_177984_a(), originalPos);
                    buildBlock.setSubBlock(upperHalf);
                }
            } else if (currentBlock instanceof BlockBed) {
                BlockBed.EnumPartType bedPart = (BlockBed.EnumPartType)currentState.func_177229_b((IProperty)BlockBed.field_176472_a);
                if (bedPart != BlockBed.EnumPartType.HEAD) continue;
                IBlockState bedFoot = null;
                boolean foundFoot = false;
                EnumFacing facing = EnumFacing.NORTH;
                while (!foundFoot) {
                    bedFoot = world.func_180495_p(currentPos.func_177972_a(facing));
                    if (bedFoot.func_177230_c() instanceof BlockBed && bedFoot.func_177229_b((IProperty)BlockBed.field_176472_a) == BlockBed.EnumPartType.FOOT) {
                        foundFoot = true;
                        break;
                    }
                    if ((facing = facing.func_176746_e()) != EnumFacing.NORTH) continue;
                }
                if (foundFoot) {
                    Block footBedBlock = bedFoot.func_177230_c();
                    BuildBlock bed = Structure.createBuildBlockFromBlockState(bedFoot, footBedBlock, currentPos.func_177972_a(facing), originalPos);
                    buildBlock.setSubBlock(bed);
                }
            }
            scannedStructure.getBlocks().add(buildBlock);
            TileEntity tileEntity = world.func_175625_s(currentPos);
            if (tileEntity == null || tileEntity instanceof TileEntityChest && ((TileEntityChest)tileEntity).func_191420_l() || tileEntity instanceof TileEntityFurnace && ((TileEntityFurnace)tileEntity).func_191420_l()) continue;
            ResourceLocation resourceLocation = TileEntity.func_190559_a(tileEntity.getClass());
            NBTTagCompound tagCompound = new NBTTagCompound();
            tileEntity.func_189515_b(tagCompound);
            BuildTileEntity buildTileEntity = new BuildTileEntity();
            buildTileEntity.setEntityDomain(resourceLocation.func_110624_b());
            buildTileEntity.setEntityName(resourceLocation.func_110623_a());
            buildTileEntity.setStartingPosition(Structure.getStartingPositionFromOriginalAndCurrentPosition(currentPos, originalPos));
            buildTileEntity.setEntityNBTData(tagCompound);
            scannedStructure.tileEntities.add(buildTileEntity);
        }
        int x_radiusRangeBegin = cornerPos1.func_177958_n() < cornerPos2.func_177958_n() ? cornerPos1.func_177958_n() : cornerPos2.func_177958_n();
        int x_radiusRangeEnd = cornerPos1.func_177958_n() < cornerPos2.func_177958_n() ? cornerPos2.func_177958_n() : cornerPos1.func_177958_n();
        int y_radiusRangeBegin = cornerPos1.func_177956_o() < cornerPos2.func_177956_o() ? cornerPos1.func_177956_o() : cornerPos2.func_177956_o();
        int y_radiusRangeEnd = cornerPos1.func_177956_o() < cornerPos2.func_177956_o() ? cornerPos2.func_177956_o() : cornerPos1.func_177956_o();
        int z_radiusRangeBegin = cornerPos1.func_177952_p() < cornerPos2.func_177952_p() ? cornerPos1.func_177952_p() : cornerPos2.func_177952_p();
        int z_radiusRangeEnd = cornerPos1.func_177952_p() < cornerPos2.func_177952_p() ? cornerPos2.func_177952_p() : cornerPos1.func_177952_p();
        for (Entity entity : world.func_72910_y()) {
            BlockPos entityPos = entity.func_180425_c();
            if (entityPos.func_177958_n() < x_radiusRangeBegin || entityPos.func_177958_n() > x_radiusRangeEnd || entityPos.func_177952_p() < z_radiusRangeBegin || entityPos.func_177952_p() > z_radiusRangeEnd || entityPos.func_177956_o() < y_radiusRangeBegin || entityPos.func_177956_o() > y_radiusRangeEnd) continue;
            BuildEntity buildEntity = new BuildEntity();
            buildEntity.setEntityId(EntityList.getID(entity.getClass()));
            buildEntity.setEntityResourceString(EntityList.func_191301_a((Entity)entity));
            buildEntity.setStartingPosition(Structure.getStartingPositionFromOriginalAndCurrentPosition(entityPos, originalPos));
            buildEntity.entityXAxisOffset = (double)entityPos.func_177958_n() - entity.field_70165_t;
            buildEntity.entityYAxisOffset = (double)entityPos.func_177956_o() - entity.field_70163_u;
            buildEntity.entityZAxisOffset = (double)entityPos.func_177952_p() - entity.field_70161_v;
            if (entity instanceof EntityItemFrame) {
                EntityItemFrame itemFrame = (EntityItemFrame)entity;
                int currentRotation = itemFrame.func_82333_j();
                int newRotation = (currentRotation + 2) % 4;
                itemFrame.func_82336_g(newRotation);
                buildEntity.entityYAxisOffset *= -1.0;
            }
            if (entity instanceof EntityHanging) {
                buildEntity.entityFacing = ((EntityHanging)entity).field_174860_b;
            }
            NBTTagCompound entityTagCompound = new NBTTagCompound();
            entity.func_189511_e(entityTagCompound);
            buildEntity.setEntityNBTData(entityTagCompound);
            scannedStructure.entities.add(buildEntity);
        }
        Structure.CreateStructureFile(scannedStructure, fileLocation);
    }

    public static BuildBlock createBuildBlockFromBlockState(IBlockState currentState, Block currentBlock, BlockPos currentPos, BlockPos originalPos) {
        BuildBlock buildBlock = new BuildBlock();
        buildBlock.setBlockDomain(currentBlock.getRegistryName().func_110624_b());
        buildBlock.setBlockName(currentBlock.getRegistryName().func_110623_a());
        buildBlock.setStartingPosition(Structure.getStartingPositionFromOriginalAndCurrentPosition(currentPos, originalPos));
        buildBlock.blockPos = currentPos;
        ImmutableMap properties = currentState.func_177228_b();
        for (Map.Entry entry : properties.entrySet()) {
            BuildProperty property = new BuildProperty();
            property.setName(((IProperty)entry.getKey()).func_177701_a());
            if (currentBlock instanceof BlockQuartz && property.getName().equals("variant")) {
                property.setValue(((BlockQuartz.EnumType)entry.getValue()).func_176610_l());
            } else if (currentBlock instanceof BlockColored || currentBlock instanceof BlockCarpet && property.getName().equals("color")) {
                EnumDyeColor dyeColor = (EnumDyeColor)entry.getValue();
                property.setValue(dyeColor.func_176610_l());
            } else {
                property.setValue(((Comparable)entry.getValue()).toString());
            }
            buildBlock.getProperties().add(property);
        }
        return buildBlock;
    }

    public static PositionOffset getStartingPositionFromOriginalAndCurrentPosition(BlockPos currentPos, BlockPos originalPos) {
        PositionOffset positionOffSet = new PositionOffset();
        if (currentPos.func_177958_n() > originalPos.func_177958_n()) {
            positionOffSet.setEastOffset(currentPos.func_177958_n() - originalPos.func_177958_n());
        } else {
            positionOffSet.setWestOffset(originalPos.func_177958_n() - currentPos.func_177958_n());
        }
        if (currentPos.func_177952_p() > originalPos.func_177952_p()) {
            positionOffSet.setSouthOffset(currentPos.func_177952_p() - originalPos.func_177952_p());
        } else {
            positionOffSet.setNorthOffset(originalPos.func_177952_p() - currentPos.func_177952_p());
        }
        positionOffSet.setHeightOffset(currentPos.func_177956_o() - originalPos.func_177956_o());
        return positionOffSet;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public BuildClear getClearSpace() {
        return this.clearSpace;
    }

    public void setClearSpace(BuildClear value) {
        this.clearSpace = value;
    }

    public ArrayList<BuildBlock> getBlocks() {
        return this.blocks;
    }

    public void setBlocks(ArrayList<BuildBlock> value) {
        this.blocks = value;
    }

    public void Initialize() {
        this.name = "";
        this.clearSpace = new BuildClear();
        this.blocks = new ArrayList();
    }

    public boolean BuildStructure(StructureConfiguration configuration, World world, BlockPos originalPos, EnumFacing assumedNorth, EntityPlayer player) {
        StructureRenderHandler2.setStructure(this, assumedNorth, configuration, world);
        if (StructureRenderHandler2.detectCollisions()) {
            TextComponentString message = new TextComponentString("Unable to build here, please use preview mode first to clear the space");
            message.func_150255_a(new Style().func_150238_a(TextFormatting.GREEN));
            player.func_145747_a((ITextComponent)message);
            return false;
        }
        if (!this.BeforeBuilding(configuration, world, originalPos, assumedNorth, player)) {
            this.ClearSpace(configuration, world, originalPos, assumedNorth);
            boolean blockPlacedWithCobbleStoneInstead = false;
            boolean slab = false;
            for (BuildBlock block : this.getBlocks()) {
                Boolean foundMapping = false;
                Block foundBlock = null;
                IBlockState iBlockState = null;
                String fullBlockName = block.getBlockDomain() + ":" + block.getBlockName();
                if (blockMappingMap.containsKey(fullBlockName)) {
                    iBlockState = blockMappingMap.get(fullBlockName);
                    if (fullBlockName.contains("_slab")) {
                        for (BuildProperty property : block.getProperties()) {
                            if (!property.getName().contains("type")) continue;
                            switch (property.getValue()) {
                                case "top": {
                                    iBlockState = iBlockState.func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.TOP);
                                    break;
                                }
                                case "double": {
                                    iBlockState = blockStateMapDoubleSlab.get(fullBlockName);
                                }
                            }
                            foundBlock = iBlockState.func_177230_c();
                            block = BuildBlock.SetBlockState(configuration, world, originalPos, assumedNorth, block, foundBlock, iBlockState, this);
                            break;
                        }
                    } else {
                        foundBlock = blockMappingMap.get(fullBlockName).func_177230_c();
                        block = BuildBlock.SetBlockState(configuration, world, originalPos, assumedNorth, block, foundBlock, iBlockState, this);
                    }
                    foundMapping = true;
                } else {
                    foundBlock = (Block)Block.field_149771_c.func_82594_a((Object)block.getResourceLocation());
                }
                if (foundBlock != null) {
                    boolean priorityFiveBlock;
                    if (!foundMapping.booleanValue()) {
                        iBlockState = foundBlock.func_176223_P();
                    }
                    BuildBlock subBlock = null;
                    if (!foundMapping.booleanValue()) {
                        block = BuildBlock.SetBlockState(configuration, world, originalPos, assumedNorth, block, foundBlock, iBlockState, this);
                    }
                    if (block.getSubBlock() != null) {
                        if (foundMapping.booleanValue()) {
                            subBlock = BuildBlock.SetBlockState(configuration, world, originalPos, assumedNorth, block.getSubBlock(), foundBlock, iBlockState, this);
                        } else {
                            foundBlock = (Block)Block.field_149771_c.func_82594_a((Object)block.getSubBlock().getResourceLocation());
                            iBlockState = foundBlock.func_176223_P();
                            subBlock = BuildBlock.SetBlockState(configuration, world, originalPos, assumedNorth, block.getSubBlock(), foundBlock, iBlockState, this);
                        }
                    }
                    if (subBlock != null) {
                        block.setSubBlock(subBlock);
                    }
                    boolean priorityTwoBlock = foundBlock instanceof BlockHopper;
                    boolean priorityThreeBlock = foundBlock instanceof BlockTorch || foundBlock instanceof BlockSign || foundBlock instanceof BlockLever || foundBlock instanceof BlockButton || foundBlock instanceof BlockBed || foundBlock instanceof BlockCarpet || foundBlock instanceof BlockFlowerPot || foundBlock instanceof BlockReed || foundBlock instanceof BlockBasePressurePlate || foundBlock instanceof BlockDoor || foundBlock instanceof BlockLadder || foundBlock instanceof BlockVine || foundBlock instanceof BlockRedstoneWire || foundBlock instanceof BlockRedstoneDiode || foundBlock instanceof BlockBanner || foundBlock instanceof BlockMushroom || foundBlock instanceof BlockRail;
                    boolean priorityFourBlock = foundBlock instanceof BlockSand;
                    boolean bl = priorityFiveBlock = foundBlock instanceof BlockReed || foundBlock instanceof BlockCactus || foundBlock instanceof BlockDeadBush || foundBlock instanceof BlockRedstoneTorch;
                    if (!block.getHasFacing()) {
                        if (subBlock != null) {
                            block.setSubBlock(subBlock);
                        }
                        if (priorityFiveBlock) {
                            this.priorityFiveBlocks.add(block);
                            continue;
                        }
                        if (priorityFourBlock) {
                            this.priorityFourBlocks.add(block);
                            continue;
                        }
                        if (priorityThreeBlock) {
                            this.priorityThreeBlocks.add(block);
                            continue;
                        }
                        if (foundBlock instanceof BlockAir) {
                            this.airBlocks.add(block);
                            continue;
                        }
                        if (foundBlock instanceof ITileEntityProvider || priorityTwoBlock) {
                            this.priorityTwoBlocks.add(block);
                            continue;
                        }
                        this.priorityOneBlocks.add(block);
                        continue;
                    }
                    if (priorityThreeBlock) {
                        this.priorityThreeBlocks.add(block);
                        continue;
                    }
                    this.priorityTwoBlocks.add(block);
                    continue;
                }
                String blockTypeNotFound = block.getResourceLocation().toString();
                block = BuildBlock.SetBlockState(configuration, world, originalPos, assumedNorth, block, Blocks.field_150347_e, Blocks.field_150347_e.func_176223_P(), this);
                this.priorityOneBlocks.add(block);
                if (blockPlacedWithCobbleStoneInstead) continue;
                blockPlacedWithCobbleStoneInstead = true;
                FMLLog.log.warn("A Block was in the structure, but it is not registered. This block was replaced with vanilla cobblestone instead. Block type not found: [" + blockTypeNotFound + "]");
            }
            this.configuration = configuration;
            this.world = world;
            this.assumedNorth = assumedNorth;
            this.originalPos = originalPos;
            if (StructureEventHandler.structuresToBuild.containsKey(player)) {
                StructureEventHandler.structuresToBuild.get(player).add(this);
            } else {
                ArrayList<Structure> structures = new ArrayList<Structure>();
                structures.add(this);
                StructureEventHandler.structuresToBuild.put(player, structures);
            }
        }
        return true;
    }

    public void BeforeClearSpaceBlockReplaced(BlockPos pos) {
    }

    public void BeforeHangingEntityRemoved(EntityHanging hangingEntity) {
    }

    public IBlockState getStainedGlassBlock(FullDyeColor color) {
        IBlockState blockState = Blocks.field_150399_cn.func_176223_P();
        blockState = color != FullDyeColor.CLEAR ? blockState.func_177226_a((IProperty)BlockStainedGlass.field_176547_a, (Comparable)color.getLinkedColor()) : Blocks.field_150359_w.func_176223_P();
        return blockState;
    }

    public IBlockState getStainedGlassPaneBlock(FullDyeColor color) {
        IBlockState blockState = Blocks.field_150397_co.func_176223_P();
        blockState = color != FullDyeColor.CLEAR ? blockState.func_177226_a((IProperty)BlockStainedGlass.field_176547_a, (Comparable)color.getLinkedColor()) : Blocks.field_150410_aZ.func_176223_P();
        return blockState;
    }

    protected boolean BeforeBuilding(StructureConfiguration configuration, World world, BlockPos originalPos, EnumFacing assumedNorth, EntityPlayer player) {
        return false;
    }

    public void AfterBuilding(StructureConfiguration configuration, World world, BlockPos originalPos, EnumFacing assumedNorth, EntityPlayer player) {
    }

    protected void ClearSpace(StructureConfiguration configuration, World world, BlockPos originalPos, EnumFacing assumedNorth) {
        if (this.clearSpace.getShape().getWidth() > 0 && this.clearSpace.getShape().getLength() > 0) {
            BlockPos startBlockPos = this.clearSpace.getStartingPosition().getRelativePosition(originalPos, this.clearSpace.getShape().getDirection(), configuration.houseFacing);
            BlockPos endBlockPos = startBlockPos.func_177967_a(configuration.houseFacing.func_176734_d().func_176746_e(), this.clearSpace.getShape().getWidth() - 1).func_177967_a(configuration.houseFacing.func_176734_d(), this.clearSpace.getShape().getLength() - 1).func_177967_a(EnumFacing.UP, this.clearSpace.getShape().getHeight());
            this.clearedBlockPos = Lists.newArrayList((Iterable)BlockPos.func_177980_a((BlockPos)startBlockPos, (BlockPos)endBlockPos));
        } else {
            this.clearedBlockPos = new ArrayList();
        }
    }

    protected Boolean CustomBlockProcessingHandled(StructureConfiguration configuration, BuildBlock block, World world, BlockPos originalPos, EnumFacing assumedNorth, Block foundBlock, IBlockState blockState, EntityPlayer player) {
        return false;
    }

    protected Boolean WaterReplacedWithCobbleStone(StructureConfiguration configuration, BuildBlock block, World world, BlockPos originalPos, EnumFacing assumedNorth, Block foundBlock, IBlockState blockState, EntityPlayer player) {
        block2: {
            block3: {
                if (!(foundBlock instanceof BlockLiquid) || blockState.func_185904_a() != Material.field_151586_h) break block2;
                if (world.field_73011_w.func_186058_p() == DimensionType.NETHER) break block3;
                if (world.field_73011_w.func_186058_p() == DimensionType.OVERWORLD) break block2;
                if (CommonProxy.proxyConfiguration.allowWaterInNonOverworldDimensions) break block2;
            }
            block.setBlockDomain(Blocks.field_150347_e.getRegistryName().func_110624_b());
            block.setBlockName(Blocks.field_150347_e.getRegistryName().func_110623_a());
            block.setBlockState(Blocks.field_150347_e.func_176223_P());
            this.priorityThreeBlocks.add(block);
            return true;
        }
        return false;
    }
}

