/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.gui.controls;

import com.wuest.prefab.gui.GuiUtils;
import com.wuest.prefab.gui.controls.GuiTabTray;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;

public class GuiTab
extends Gui {
    protected static final ResourceLocation TAB_TEXTURES = new ResourceLocation("prefab", "textures/gui/gui_tab.png");
    protected static final ResourceLocation TAB_TEXTURES_hovered = new ResourceLocation("prefab", "textures/gui/gui_tab_hovered.png");
    public boolean visible;
    public int width;
    public int height;
    public int xPosition;
    public int yPosition;
    protected boolean hovered;
    private GuiTabTray parentTray;
    private boolean selected;
    private String name;

    public GuiTab(GuiTabTray parent, String name, int x, int y) {
        this.Initialize(parent, name, x, y);
    }

    protected void Initialize(GuiTabTray parent, String name, int x, int y) {
        this.parentTray = parent;
        this.selected = false;
        this.name = name;
        this.height = 20;
        this.width = 50;
        this.xPosition = x;
        this.yPosition = y;
        this.visible = true;
    }

    public GuiTabTray getParent() {
        return this.parentTray;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) throws Exception {
        if (this.parentTray.DoesTabNameExist(value)) {
            Exception exception = new Exception("A tab with the name of [" + value + "] already exists.");
            throw exception;
        }
        this.name = value;
    }

    public boolean getIsSelected() {
        return this.selected;
    }

    public void setIsSelected(boolean value) {
        this.selected = value;
        this.parentTray.SetSelectedTab(this.selected ? this : null);
    }

    protected void InternalSetSelected(boolean value) {
        this.selected = value;
    }

    public void drawTab(Minecraft mc, int mouseX, int mouseY) {
        if (!this.visible) {
            return;
        }
        FontRenderer fontrenderer = mc.field_71466_p;
        boolean bl = this.hovered = mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
        if (this.selected || this.hovered) {
            mc.func_110434_K().func_110577_a(TAB_TEXTURES_hovered);
        } else {
            mc.func_110434_K().func_110577_a(TAB_TEXTURES);
        }
        GuiUtils.drawModalRectWithCustomSizedTexture(this.xPosition, this.yPosition, 0, this.width, this.height, this.width, this.height);
        this.mouseDragged(mc, mouseX, mouseY);
        int j = Color.LIGHT_GRAY.getRGB();
        int stringXPosition = this.xPosition + this.width / 2 - fontrenderer.func_78256_a(this.name) / 2;
        fontrenderer.func_78276_b(this.name, stringXPosition, this.yPosition + (this.height - 8) / 2, j);
    }

    protected void mouseDragged(Minecraft mc, int mouseX, int mouseY) {
    }

    public void mouseReleased(int mouseX, int mouseY) {
    }

    public boolean mousePressed(Minecraft mc, int mouseX, int mouseY) {
        boolean value;
        boolean bl = value = mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
        if (value && !this.selected) {
            this.setIsSelected(true);
        }
        return value;
    }

    public boolean isMouseOver() {
        return this.hovered;
    }

    public void drawButtonForegroundLayer(int mouseX, int mouseY) {
    }

    public void playPressSound(SoundHandler soundHandlerIn) {
        soundHandlerIn.func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }

    public int getButtonWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }
}

