/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.engine.waila;

import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaEntityAccessor;
import mcp.mobius.waila.api.IWailaEntityProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.darkhax.wawla.Wawla;
import net.darkhax.wawla.lib.InfoAccess;
import net.darkhax.wawla.plugins.FeatureManager;
import net.darkhax.wawla.plugins.InfoProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class EntityProvider
implements IWailaEntityProvider {
    public Entity getWailaOverride(IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        try {
            InfoAccess info = new InfoAccess(accessor.getWorld(), accessor.getPlayer(), accessor.getEntity(), accessor.getNBTData());
            if (info.entity != null) {
                for (InfoProvider provider : FeatureManager.entityProviders) {
                    if (!provider.requireEntityOverride(info)) continue;
                    info = provider.overrideEntity(info);
                }
            }
            return info.entity;
        }
        catch (Exception e) {
            Wawla.LOG.trace("Could not process override for " + accessor.getEntity().func_70005_c_(), (Throwable)e);
            return accessor.getEntity();
        }
    }

    public List<String> getWailaHead(Entity entity, List<String> currenttip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public List<String> getWailaBody(Entity entity, List<String> currenttip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        InfoAccess info = new InfoAccess(accessor.getWorld(), accessor.getPlayer(), accessor.getEntity(), accessor.getNBTData());
        for (InfoProvider provider : FeatureManager.entityProviders) {
            provider.addEntityInfo(currenttip, info);
        }
        return currenttip;
    }

    public List<String> getWailaTail(Entity entity, List<String> currenttip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, Entity ent, NBTTagCompound tag, World world) {
        for (InfoProvider provider : FeatureManager.entityProviders) {
            if (!provider.requireEntitySync(world, ent)) continue;
            provider.writeEntityNBT(world, ent, tag);
        }
        return tag;
    }

    public static void register(IWailaRegistrar register) {
        EntityProvider provider = new EntityProvider();
        register.registerOverrideEntityProvider((IWailaEntityProvider)provider, Entity.class);
        register.registerBodyProvider((IWailaEntityProvider)provider, Entity.class);
        register.registerNBTProvider((IWailaEntityProvider)provider, Entity.class);
    }
}

