/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat.patchouli;

import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.api.ICustomComponent;
import vazkii.patchouli.api.VariableHolder;
import vazkii.patchouli.common.util.ItemStackUtil;

public class GalleryComponent
implements ICustomComponent {
    int x;
    int y;
    @SerializedName(value="table_x")
    int xCount = 6;
    @VariableHolder
    public String items;
    private transient List<ItemStack> stacks;
    private static final transient Minecraft mc = Minecraft.func_71410_x();

    public void build(int x, int y, int pageNum) {
        this.stacks = Arrays.stream(this.items.split("\\|")).map(ItemStackUtil::loadStackFromString).filter(i -> !i.func_190926_b()).collect(Collectors.toList());
        if (this.xCount <= 0 || this.xCount > 6) {
            this.xCount = MathHelper.func_76125_a((int)this.stacks.size(), (int)1, (int)6);
        }
    }

    public void render(IComponentRenderContext context, float pTicks, int mouseX, int mouseY) {
        int x = this.x + 5;
        int y = this.y;
        int listSize = this.stacks.size();
        int extras = Math.floorMod(listSize, this.xCount);
        int listBlock = listSize - extras;
        for (int c = 0; c < listSize; ++c) {
            ItemStack stack = this.stacks.get(c);
            int column = Math.floorMod(c, this.xCount);
            int row = c / this.xCount;
            if (c < listBlock) {
                context.renderItemStack(column * 18 + x, row * 18 + y, mouseX, mouseY, stack);
                continue;
            }
            int columnPushed = column * 18 + 54 - extras * 9;
            context.renderItemStack(columnPushed + x, row * 18 + y, mouseX, mouseY, stack);
        }
    }
}

