/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.biomes;

import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenPumpkin;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.block.BlockTFPlant;
import twilightforest.block.TFBlocks;
import twilightforest.entity.EntityTFSkeletonDruid;
import twilightforest.enums.PlantVariant;
import twilightforest.features.TFGenGraveyard;
import twilightforest.world.TFWorld;
import twilightforest.world.feature.TFGenCanopyTree;
import twilightforest.world.feature.TFGenFallenLeaves;
import twilightforest.world.feature.TFGenLampposts;
import twilightforest.world.feature.TFGenTallGrass;
import twilightforest.world.feature.TFGenWebs;

public class TFBiomeSpookyForest
extends TFBiomeBase {
    private final WorldGenerator tfGenWebs = new TFGenWebs();
    private final WorldGenerator tfGenLeaf = new TFGenFallenLeaves();
    private final WorldGenerator tfGenLampposts = new TFGenLampposts(Blocks.field_150428_aP.func_176223_P());
    private final WorldGenerator worldGenMushgloom = new TFGenTallGrass(TFBlocks.twilight_plant.func_176223_P().func_177226_a(BlockTFPlant.VARIANT, (Comparable)((Object)PlantVariant.MUSHGLOOM)));
    private final WorldGenerator worldGenDeadBush = new TFGenTallGrass(TFBlocks.twilight_plant.func_176223_P().func_177226_a(BlockTFPlant.VARIANT, (Comparable)((Object)PlantVariant.DEADBUSH)), 8);
    private final WorldGenerator graveyardGen = new TFGenGraveyard();
    private final WorldGenerator worldGenPumpkin = new WorldGenPumpkin();

    public TFBiomeSpookyForest(Biome.BiomeProperties props) {
        super(props);
        this.getTFBiomeDecorator().setFlowersPerChunk(1);
        this.getTFBiomeDecorator().setGrassPerChunk(4);
        this.getTFBiomeDecorator().setTreesPerChunk(2);
        this.getTFBiomeDecorator().hasCanopy = false;
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityTFSkeletonDruid.class, 10, 1, 3));
    }

    public void func_180624_a(World world, Random rand, BlockPos pos) {
        int ry;
        int rz;
        int rx;
        int rz2;
        int rx2;
        int i;
        super.func_180624_a(world, rand, pos);
        float canopyPerChunk = 1.7f;
        int nc = (int)canopyPerChunk + (rand.nextFloat() < canopyPerChunk - (float)((int)canopyPerChunk) ? 1 : 0);
        for (i = 0; i < nc; ++i) {
            rx2 = pos.func_177958_n() + rand.nextInt(16) + 8;
            rz2 = pos.func_177952_p() + rand.nextInt(16) + 8;
            BlockPos genPos = new BlockPos(rx2, world.func_189649_b(rx2, rz2), rz2);
            ((TFGenCanopyTree)this.getTFBiomeDecorator().canopyTreeGen).generate(world, rand, genPos, false);
        }
        if (rand.nextInt(24) == 0) {
            rx = pos.func_177958_n() + rand.nextInt(16) + 8;
            rz = pos.func_177952_p() + rand.nextInt(16) + 8;
            ry = TFWorld.getGroundLevel(world, rx, rz);
            this.worldGenMushgloom.func_180709_b(world, rand, new BlockPos(rx, ry, rz));
        }
        for (i = 0; i < 36; ++i) {
            rx2 = pos.func_177958_n() + rand.nextInt(30) + 2;
            rz2 = pos.func_177952_p() + rand.nextInt(30) + 2;
            int ry2 = 31 + rand.nextInt(225);
            this.tfGenWebs.func_180709_b(world, rand, new BlockPos(rx2, ry2, rz2));
        }
        if (rand.nextInt(2) == 0) {
            rx = pos.func_177958_n() + rand.nextInt(30) + 2;
            rz = pos.func_177952_p() + rand.nextInt(30) + 2;
            ry = TFWorld.getGroundLevel(world, rx, rz);
            this.tfGenLampposts.func_180709_b(world, rand, new BlockPos(rx, ry, rz));
        }
        if (rand.nextInt(16) == 0) {
            rx = pos.func_177958_n() + rand.nextInt(16) + 8;
            rz = pos.func_177952_p() + rand.nextInt(16) + 8;
            ry = TFWorld.getGroundLevel(world, rx, rz);
            this.worldGenPumpkin.func_180709_b(world, rand, new BlockPos(rx, ry, rz));
        }
        for (i = 0; i < 6; ++i) {
            rx2 = pos.func_177958_n() + rand.nextInt(16) + 8;
            rz2 = pos.func_177952_p() + rand.nextInt(16) + 8;
            this.worldGenDeadBush.func_180709_b(world, rand, new BlockPos(rx2, world.func_189649_b(rx2, rz2), rz2));
        }
        for (i = 0; i < 6; ++i) {
            rx2 = pos.func_177958_n() + rand.nextInt(25) + 2;
            rz2 = pos.func_177952_p() + rand.nextInt(25) + 2;
            this.tfGenLeaf.func_180709_b(world, rand, new BlockPos(rx2, world.func_189649_b(rx2, rz2), rz2));
        }
        if (rand.nextFloat() < 0.05f) {
            rx = pos.func_177958_n() + rand.nextInt(16) + 8;
            rz = pos.func_177952_p() + rand.nextInt(16) + 8;
            this.graveyardGen.func_180709_b(world, rand, new BlockPos(rx, world.func_189649_b(rx, rz), rz));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180627_b(BlockPos pos) {
        return 12865827;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180625_c(BlockPos pos) {
        return 16745729;
    }
}

