/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.biomes;

import java.util.Random;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenerator;
import twilightforest.TFFeature;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.block.BlockTFPlant;
import twilightforest.block.TFBlocks;
import twilightforest.enums.PlantVariant;
import twilightforest.world.feature.TFGenLargeRainboak;
import twilightforest.world.feature.TFGenSmallRainboak;
import twilightforest.world.feature.TFGenTallGrass;
import twilightforest.world.feature.TFGenVines;

public class TFBiomeEnchantedForest
extends TFBiomeBase {
    private final Random colorRNG = new Random();

    public TFBiomeEnchantedForest(Biome.BiomeProperties props) {
        super(props);
        this.getTFBiomeDecorator().setGrassPerChunk(12);
        this.getTFBiomeDecorator().setFlowersPerChunk(8);
    }

    public int func_180627_b(BlockPos pos) {
        return (super.func_180627_b(pos) & 0xFFFF00) + this.getEnchantedColor(pos.func_177958_n(), pos.func_177952_p());
    }

    public int func_180625_c(BlockPos pos) {
        return (super.func_180625_c(pos) & 0xFFFF00) + this.getEnchantedColor(pos.func_177958_n(), pos.func_177952_p());
    }

    private int getEnchantedColor(int x, int z) {
        int randomFlicker;
        int cx = 256 * Math.round((float)(x - 8) / 256.0f) + 8;
        int cz = 256 * Math.round((float)(z - 8) / 256.0f) + 8;
        int dist = (int)MathHelper.func_76129_c((float)((cx - x) * (cx - x) + (cz - z) * (cz - z)));
        int color = dist * 64;
        if ((color %= 512) > 255) {
            color = 511 - color;
        }
        if (0 < (color = 255 - color) + (randomFlicker = this.colorRNG.nextInt(32) - 16) && color + randomFlicker > 255) {
            color += randomFlicker;
        }
        return color;
    }

    @Override
    public WorldGenAbstractTree func_150567_a(Random random) {
        if (random.nextInt(15) == 0) {
            return new TFGenSmallRainboak();
        }
        if (random.nextInt(50) == 0) {
            return new TFGenLargeRainboak();
        }
        if (random.nextInt(5) == 0) {
            return this.birchGen;
        }
        if (random.nextInt(10) == 0) {
            return new WorldGenBigTree(false);
        }
        return field_76757_N;
    }

    @Override
    public WorldGenerator func_76730_b(Random random) {
        if (random.nextInt(3) > 0) {
            return new WorldGenTallGrass(BlockTallGrass.EnumType.FERN);
        }
        if (random.nextInt(3) == 0) {
            return new TFGenTallGrass(TFBlocks.twilight_plant.func_176223_P().func_177226_a(BlockTFPlant.VARIANT, (Comparable)((Object)PlantVariant.FIDDLEHEAD)));
        }
        return new WorldGenTallGrass(BlockTallGrass.EnumType.GRASS);
    }

    public void func_180624_a(World world, Random rand, BlockPos pos) {
        int rx;
        int i;
        BlockPos.MutableBlockPos mutPos = new BlockPos.MutableBlockPos();
        TFGenVines vines = new TFGenVines();
        for (i = 0; i < 20; ++i) {
            rx = pos.func_177958_n() + rand.nextInt(16) + 8;
            int ry = 159;
            int rz = pos.func_177952_p() + rand.nextInt(16) + 8;
            vines.func_180709_b(world, rand, (BlockPos)mutPos.func_181079_c(rx, ry, rz));
        }
        field_180280_ag.func_180710_a(BlockDoublePlant.EnumPlantType.FERN);
        for (i = 0; i < 20; ++i) {
            rx = pos.func_177958_n() + rand.nextInt(16) + 8;
            int rz = pos.func_177952_p() + rand.nextInt(16) + 8;
            int ry = rand.nextInt(world.func_189649_b(rx, rz) + 32);
            field_180280_ag.func_180709_b(world, rand, (BlockPos)mutPos.func_181079_c(rx, ry, rz));
        }
        super.func_180624_a(world, rand, pos);
    }

    public BlockFlower.EnumFlowerType func_180623_a(Random rand, BlockPos pos) {
        double d0 = MathHelper.func_151237_a((double)((1.0 + field_180281_af.func_151601_a((double)pos.func_177958_n() / 48.0, (double)pos.func_177952_p() / 48.0)) / 2.0), (double)0.0, (double)0.9999);
        BlockFlower.EnumFlowerType blockflower$enumflowertype = BlockFlower.EnumFlowerType.values()[(int)(d0 * (double)BlockFlower.EnumFlowerType.values().length)];
        return blockflower$enumflowertype == BlockFlower.EnumFlowerType.BLUE_ORCHID ? BlockFlower.EnumFlowerType.POPPY : blockflower$enumflowertype;
    }

    public void addDefaultFlowers() {
        for (BlockFlower.EnumFlowerType flowerType : Blocks.field_150327_N.func_176494_l().func_177700_c()) {
            this.addFlower(Blocks.field_150327_N.func_176223_P().func_177226_a(Blocks.field_150327_N.func_176494_l(), (Comparable)flowerType), 10);
        }
        for (BlockFlower.EnumFlowerType flowerType : Blocks.field_150328_O.func_176494_l().func_177700_c()) {
            this.addFlower(Blocks.field_150328_O.func_176223_P().func_177226_a(Blocks.field_150328_O.func_176494_l(), (Comparable)flowerType), 10);
        }
    }

    @Override
    protected TFFeature getContainedFeature() {
        return TFFeature.QUEST_GROVE;
    }
}

