/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.biomes;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenBirchTree;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenerator;
import twilightforest.TFFeature;
import twilightforest.biomes.TFBiomeDecorator;
import twilightforest.entity.EntityTFKingSpider;
import twilightforest.entity.EntityTFKobold;
import twilightforest.entity.EntityTFMistWolf;
import twilightforest.entity.passive.EntityTFBighorn;
import twilightforest.entity.passive.EntityTFBoar;
import twilightforest.entity.passive.EntityTFDeer;
import twilightforest.entity.passive.EntityTFRaven;
import twilightforest.entity.passive.EntityTFSquirrel;
import twilightforest.entity.passive.EntityTFTinyBird;
import twilightforest.util.PlayerHelper;
import twilightforest.world.ChunkGeneratorTFBase;
import twilightforest.world.TFWorld;

public class TFBiomeBase
extends Biome {
    protected final WorldGenAbstractTree birchGen = new WorldGenBirchTree(false, false);
    protected final List<Biome.SpawnListEntry> undergroundMonsterList = new ArrayList<Biome.SpawnListEntry>();
    protected final ResourceLocation[] requiredAdvancements = this.getRequiredAdvancements();
    public final TFFeature containedFeature = this.getContainedFeature();

    public TFBiomeBase(Biome.BiomeProperties props) {
        super(props);
        this.field_76761_J.clear();
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityTFKingSpider.class, 2, 1, 1));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityTFMistWolf.class, 2, 1, 1));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityCreeper.class, 3, 2, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityTFKobold.class, 3, 2, 4));
        this.field_76755_L.clear();
        this.field_76762_K.clear();
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityTFBighorn.class, 5, 2, 4));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityTFBoar.class, 5, 2, 4));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityTFDeer.class, 5, 2, 4));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityTFTinyBird.class, 5, 2, 4));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityTFSquirrel.class, 5, 2, 4));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityTFRaven.class, 5, 1, 2));
        this.field_82914_M.clear();
        this.getTFBiomeDecorator().setTreesPerChunk(10);
        this.getTFBiomeDecorator().setGrassPerChunk(2);
    }

    public float func_76741_f() {
        return 0.12f;
    }

    public TFBiomeDecorator createBiomeDecorator() {
        return new TFBiomeDecorator();
    }

    protected TFBiomeDecorator getTFBiomeDecorator() {
        return (TFBiomeDecorator)this.field_76760_I;
    }

    public WorldGenAbstractTree func_150567_a(Random random) {
        if (random.nextInt(5) == 0) {
            return this.birchGen;
        }
        if (random.nextInt(10) == 0) {
            return new WorldGenBigTree(false);
        }
        return field_76757_N;
    }

    public WorldGenerator func_76730_b(Random random) {
        if (random.nextInt(4) == 0) {
            return new WorldGenTallGrass(BlockTallGrass.EnumType.FERN);
        }
        return new WorldGenTallGrass(BlockTallGrass.EnumType.GRASS);
    }

    public void func_180622_a(World world, Random rand, ChunkPrimer primer, int x, int z, double noiseVal) {
        this.genTwilightBiomeTerrain(world, rand, primer, x, z, noiseVal);
    }

    protected void genTwilightBiomeTerrain(World world, Random rand, ChunkPrimer primer, int x, int z, double noiseVal) {
        int i = 31;
        IBlockState iblockstate = this.field_76752_A;
        IBlockState iblockstate1 = this.field_76753_B;
        IBlockState stoneReplacement = this.getStoneReplacementState();
        int j = -1;
        int k = (int)(noiseVal / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        int l = x & 0xF;
        int i1 = z & 0xF;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        boolean generateBedrock = TFBiomeBase.shouldGenerateBedrock(world);
        for (int j1 = 255; j1 >= 0; --j1) {
            if (generateBedrock && j1 <= rand.nextInt(5)) {
                primer.func_177855_a(i1, j1, l, field_185367_c);
                continue;
            }
            IBlockState iblockstate2 = primer.func_177856_a(i1, j1, l);
            if (iblockstate2.func_177230_c() == Blocks.field_150350_a || iblockstate2.func_177230_c() != Blocks.field_150348_b) continue;
            if (j == -1) {
                if (k <= 0) {
                    iblockstate = field_185366_b;
                    iblockstate1 = field_185365_a;
                } else if (j1 >= i - 4 && j1 <= i + 1) {
                    iblockstate = this.field_76752_A;
                    iblockstate1 = this.field_76753_B;
                }
                if (j1 < i && (iblockstate == null || iblockstate.func_177230_c() == Blocks.field_150350_a)) {
                    iblockstate = this.func_180626_a((BlockPos)blockpos$mutableblockpos.func_181079_c(x, j1, z)) < 0.15f ? field_185371_g : field_185372_h;
                }
                j = k;
                if (j1 >= i - 1) {
                    primer.func_177855_a(i1, j1, l, iblockstate);
                    continue;
                }
                if (j1 < i - 7 - k) {
                    iblockstate = field_185366_b;
                    iblockstate1 = field_185365_a;
                    primer.func_177855_a(i1, j1, l, field_185368_d);
                    continue;
                }
                primer.func_177855_a(i1, j1, l, iblockstate1);
                continue;
            }
            if (j > 0) {
                primer.func_177855_a(i1, j1, l, iblockstate1);
                if (--j != 0 || iblockstate1.func_177230_c() != Blocks.field_150354_m) continue;
                j = rand.nextInt(4) + Math.max(0, j1 - 63);
                iblockstate1 = iblockstate1.func_177229_b((IProperty)BlockSand.field_176504_a) == BlockSand.EnumType.RED_SAND ? field_185369_e : field_185370_f;
                continue;
            }
            if (stoneReplacement == null) continue;
            primer.func_177855_a(i1, j1, l, stoneReplacement);
        }
    }

    private static boolean shouldGenerateBedrock(World world) {
        ChunkGeneratorTFBase generator = TFWorld.getChunkGenerator(world);
        return generator == null || generator.shouldGenerateBedrock();
    }

    @Nullable
    public IBlockState getStoneReplacementState() {
        return null;
    }

    public boolean doesPlayerHaveRequiredAdvancements(EntityPlayer player) {
        return PlayerHelper.doesPlayerHaveRequiredAdvancements(player, this.requiredAdvancements);
    }

    protected ResourceLocation[] getRequiredAdvancements() {
        return new ResourceLocation[0];
    }

    public void enforceProgression(EntityPlayer player, World world) {
    }

    protected void trySpawnHintMonster(EntityPlayer player, World world) {
        if (world.field_73012_v.nextInt(4) == 0) {
            this.containedFeature.trySpawnHintMonster(world, player);
        }
    }

    protected TFFeature getContainedFeature() {
        return TFFeature.NOTHING;
    }

    public List<Biome.SpawnListEntry> getUndergroundSpawnableList(EnumCreatureType type) {
        return type == EnumCreatureType.MONSTER ? this.undergroundMonsterList : this.func_76747_a(type);
    }
}

