/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.triumph.advancements.criterion.data.immersiveengineering;

import blusunrize.immersiveengineering.common.util.advancements.MultiblockTrigger;
import com.bloodnbonesgaming.lib.util.data.ItemBlockData;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.CriterionTriggerData;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;

@ScriptClassDocumentation(documentationFile="./config/triumph/documentation/criteria/triggers/immersiveengineering/multiblock_formed", classExplaination="These are the functions which can be called on a immersiveengineering:multiblock_formed criteria trigger. This criteria is triggered by a player forming an Immersive Engineering multiblock.")
public class MultiblockFormationTriggerData
extends CriterionTriggerData {
    private String multiblock = "";
    ItemPredicate itemPredicate = ItemPredicate.field_192495_a;
    private ItemBlockData itemData = new ItemBlockData();

    public MultiblockFormationTriggerData(String criterionName, String advancementName) {
        super(criterionName, advancementName);
    }

    @Override
    public Criterion buildCriterion() throws Exception {
        ItemPredicate item = this.itemPredicate == ItemPredicate.field_192495_a ? this.itemData.buildItemPredicate() : this.itemPredicate;
        return new Criterion((ICriterionInstance)new MultiblockTrigger.Instance(this.multiblock, item));
    }

    @ScriptMethodDocumentation(args="ItemBlockData", usage="item data", notes="Sets the required item.")
    public void setItem(ItemBlockData data) throws Exception {
        this.itemPredicate = data.buildItemPredicate();
    }

    @ScriptMethodDocumentation(args="String", usage="multiblock id", notes="Sets the id for the multiblock this trigger will be triggerd by the formation of.")
    public void setMultiblock(String multiblock) {
        this.multiblock = multiblock;
    }

    public ItemBlockData getHammerData() {
        return this.itemData;
    }

    public ItemBlockData setHammer(String itemName) {
        return this.setHammer(itemName, null);
    }

    public ItemBlockData setHammer(String itemName, Integer meta) {
        this.itemData.setLocation(itemName);
        this.itemData.setMeta(meta != null ? new MinMaxBounds(Float.valueOf(meta.floatValue()), Float.valueOf(meta.floatValue())) : MinMaxBounds.field_192516_a);
        return this.itemData;
    }

    public ItemBlockData setHammer(String itemName, Integer meta, String nbt) throws Exception {
        this.itemData.setLocation(itemName);
        this.itemData.setMeta(meta != null ? new MinMaxBounds(Float.valueOf(meta.floatValue()), Float.valueOf(meta.floatValue())) : MinMaxBounds.field_192516_a);
        this.itemData.setNBT(nbt);
        return this.itemData;
    }

    public ItemBlockData setHammerOreDict(String oreDict) throws Exception {
        this.itemData.setOre(oreDict);
        return this.itemData;
    }
}

