/*
 * Decompiled with CFR 0.152.
 */
package org.thetorg.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public class PlayerData
extends WorldSavedData {
    private static final String DATA_NAME = "player_data";
    public Map<UUID, String> playerMap = new HashMap<UUID, String>();

    public PlayerData() {
        super(DATA_NAME);
    }

    public PlayerData(String name) {
        super(name);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c("players", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound playerData = list.func_150305_b(i);
            UUID uuid = UUID.fromString(playerData.func_74779_i("uuid"));
            String name = playerData.func_74779_i("name");
            this.playerMap.put(uuid, name);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<UUID, String> entry : this.playerMap.entrySet()) {
            NBTTagCompound playerData = new NBTTagCompound();
            playerData.func_74778_a("uuid", entry.getKey().toString());
            playerData.func_74778_a("name", entry.getValue());
            list.func_74742_a((NBTBase)playerData);
        }
        compound.func_74782_a("players", (NBTBase)list);
        return compound;
    }

    public void addPlayer(UUID uuid, String name) {
        this.playerMap.put(uuid, name);
        this.func_76185_a();
    }

    public String getPlayerName(UUID uuid) {
        return this.playerMap.get(uuid);
    }

    public static PlayerData get(World world) {
        MapStorage storage = world.getPerWorldStorage();
        PlayerData instance = (PlayerData)storage.func_75742_a(PlayerData.class, DATA_NAME);
        if (instance == null) {
            instance = new PlayerData();
            storage.func_75745_a(DATA_NAME, (WorldSavedData)instance);
        }
        return instance;
    }
}

