/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.gui.client.storage;

import cofh.api.core.ISecurable;
import cofh.api.tileentity.IRedstoneControl;
import cofh.core.gui.GuiContainerCore;
import cofh.core.gui.container.ContainerTileAugmentable;
import cofh.core.gui.element.ElementBase;
import cofh.core.gui.element.ElementButton;
import cofh.core.gui.element.ElementFluidTank;
import cofh.core.gui.element.tab.TabBase;
import cofh.core.gui.element.tab.TabInfo;
import cofh.core.gui.element.tab.TabRedstoneControl;
import cofh.core.gui.element.tab.TabSecurity;
import cofh.core.util.helpers.SecurityHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.block.storage.TileTank;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public class GuiTank
extends GuiContainerCore {
    public static final String TEX_PATH = "thermalexpansion:textures/gui/storage/tank.png";
    public static final ResourceLocation TEXTURE = new ResourceLocation("thermalexpansion:textures/gui/storage/tank.png");
    protected TileTank baseTile;
    protected UUID playerName;
    protected TabBase redstoneTab;
    protected TabBase securityTab;
    private ElementButton output;
    private ElementButton lock;

    public GuiTank(InventoryPlayer inventory, TileEntity tile) {
        super((Container)new ContainerTileAugmentable(inventory, tile), TEXTURE);
        this.baseTile = (TileTank)tile;
        this.name = this.baseTile.func_70005_c_();
        this.playerName = SecurityHelper.getID((EntityPlayer)inventory.field_70458_d);
        this.generateInfo("tab.thermalexpansion.storage.tank");
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.redstoneTab = this.addTab((TabBase)new TabRedstoneControl((GuiContainerCore)this, (IRedstoneControl)this.baseTile));
        this.securityTab = this.addTab((TabBase)new TabSecurity((GuiContainerCore)this, (ISecurable)this.baseTile, this.playerName));
        this.securityTab.setVisible(this.baseTile.enableSecurity() && this.baseTile.isSecured());
        if (!this.myInfo.isEmpty()) {
            this.addTab((TabBase)new TabInfo((GuiContainerCore)this, this.myInfo));
        }
        this.addElement((ElementBase)new ElementFluidTank((GuiContainerCore)this, 80, 19, (IFluidTank)this.baseTile.getTank()).setMedium().setGauge(0).setAlwaysShow(true).setInfinite(this.baseTile.isCreative));
        this.output = new ElementButton((GuiContainerCore)this, 35, 41, "Output", 176, 0, 176, 16, 176, 32, 16, 16, TEX_PATH).setToolTipLocalized(true);
        this.lock = new ElementButton((GuiContainerCore)this, 125, 41, "Lock", 176, 48, 176, 64, 176, 80, 16, 16, TEX_PATH).setToolTipLocalized(true);
        this.addElement((ElementBase)this.output);
        this.addElement((ElementBase)this.lock);
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (!this.baseTile.canAccess()) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        this.redstoneTab.setVisible(this.baseTile.hasRedstoneControl());
        this.securityTab.setVisible(this.baseTile.enableSecurity() && this.baseTile.isSecured());
    }

    protected void updateElementInformation() {
        super.updateElementInformation();
        if (this.baseTile.getTransferOut()) {
            this.output.setToolTip(StringHelper.localize((String)"gui.cofh.transferOutEnabled"));
            this.output.setSheetX(176);
            this.output.setHoverX(176);
        } else {
            this.output.setToolTip(StringHelper.localize((String)"gui.cofh.transferOutDisabled"));
            this.output.setSheetX(192);
            this.output.setHoverX(192);
        }
        if (this.baseTile.getTankFluid() == null) {
            this.lock.setDisabled();
        } else {
            this.lock.setActive();
        }
        if (this.baseTile.isLocked()) {
            FluidStack fluid = this.baseTile.getTankFluid();
            String color = fluid.getFluid().getRarity().field_77937_e.toString();
            this.lock.setToolTip(StringHelper.localize((String)"info.cofh.locked") + ": " + color + StringHelper.localize((String)fluid.getFluid().getLocalizedName(fluid)) + "\u00a7r");
            this.lock.setSheetX(176);
            this.lock.setHoverX(176);
        } else {
            this.lock.setToolTip(StringHelper.localize((String)"info.cofh.unlocked"));
            this.lock.setSheetX(192);
            this.lock.setHoverX(192);
        }
    }

    public void handleElementButtonClick(String buttonName, int mouseButton) {
        if (buttonName.equalsIgnoreCase("Output")) {
            if (this.baseTile.setTransferOut(!this.baseTile.getTransferOut())) {
                GuiTank.playClickSound((float)(this.baseTile.getTransferOut() ? 0.8f : 0.4f));
            }
        } else if (buttonName.equalsIgnoreCase("Lock")) {
            this.baseTile.toggleLock();
            GuiTank.playClickSound((float)(this.baseTile.isLocked() ? 0.8f : 0.4f));
            this.baseTile.sendModePacket();
            this.baseTile.toggleLock();
        }
    }
}

