/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.simplequarry.vortex;

import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;

public class Vortex
implements ITickable {
    public final int world;
    private final int hashCode;
    protected double x;
    protected double y;
    protected double z;
    protected double vortexStrenght;
    protected double radius = 1.0;
    protected AxisAlignedBB boundingBox;

    public Vortex(int world, double x, double y, double z, double vortexStrenght, boolean includeStrenghtInHash) {
        this.world = world;
        this.hashCode = ("" + x + "," + y + "," + z + "x" + (includeStrenghtInHash ? vortexStrenght : 0.0)).hashCode();
        this.vortexStrenght = vortexStrenght;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vortex(int world, double x, double y, double z, double vortexStrenght, double radius, boolean includeStrenghtInHash) {
        this(world, x, y, z, vortexStrenght, includeStrenghtInHash);
        this.radius = radius;
        this.rebuildBoundingBox();
    }

    public AxisAlignedBB rebuildBoundingBox() {
        this.boundingBox = new AxisAlignedBB(this.x - this.radius, this.y - this.radius, this.z - this.radius, this.x + this.radius, this.y + this.radius, this.z + this.radius);
        return this.boundingBox;
    }

    public AxisAlignedBB getBoundingBox() {
        if (this.boundingBox == null || this.boundingBox.field_72336_d - this.boundingBox.field_72340_a != this.radius * 2.0 || this.boundingBox.field_72336_d - this.radius != this.x || this.boundingBox.field_72337_e - this.radius != this.y || this.boundingBox.field_72334_f - this.radius != this.z) {
            this.rebuildBoundingBox();
        }
        return this.boundingBox;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getVortexStrength() {
        return this.vortexStrenght;
    }

    public int getHashCode() {
        return this.hashCode;
    }

    public void func_73660_a() {
    }

    public int hashCode() {
        return this.getHashCode();
    }
}

