/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.integration.patch;

import com.therandomlabs.randompatches.core.Patch;
import com.therandomlabs.randompatches.integration.repackage.com.therandomlabs.randomlib.TRLUtils;
import gd.izno.mc.muon.MuonHeightMap;
import gd.izno.mc.muon.MuonHooks;
import gd.izno.mc.muon.MuonUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;

public final class VillagePatch
extends Patch {
    public boolean apply(ClassNode classNode) {
        InsnList instructions = VillagePatch.findInstructions((ClassNode)classNode, (String)"getAverageGroundLevel", (String)"func_74889_b");
        for (int i = 0; i < instructions.size(); ++i) {
            AbstractInsnNode instruction = instructions.get(i);
            if (instruction.getOpcode() != 184) continue;
            MethodInsnNode method = (MethodInsnNode)instruction;
            if (!"gd/izno/mc/muon/MuonHooks".equals(method.owner)) continue;
            method.owner = VillagePatch.getName(VillagePatch.class) + "$Hook";
            break;
        }
        return true;
    }

    public static final class Hook {
        private static final Method GET_HEIGHT = TRLUtils.findMethod(MuonHeightMap.class, "getHeight", Integer.TYPE, Integer.TYPE);

        public static int getAverageGroundLevel(StructureComponent village, World world, StructureBoundingBox structureBoundingBox) {
            StructureBoundingBox villageBoundingBox = village.func_74874_b();
            int i = 0;
            int j = 0;
            int minY = -1;
            int minX = villageBoundingBox.field_78897_a - 1;
            int minZ = villageBoundingBox.field_78896_c - 1;
            int maxX = villageBoundingBox.field_78893_d + 1;
            int maxZ = villageBoundingBox.field_78892_f + 1;
            EnumFacing facing = village.func_186165_e();
            if (facing != null && (maxX - minX + 1 != 8 || maxZ - minZ + 1 != 8)) {
                switch (facing) {
                    case NORTH: {
                        minZ = villageBoundingBox.field_78892_f;
                        break;
                    }
                    case SOUTH: {
                        maxZ = villageBoundingBox.field_78896_c;
                        break;
                    }
                    case WEST: {
                        minX = villageBoundingBox.field_78893_d;
                        break;
                    }
                    case EAST: {
                        maxX = villageBoundingBox.field_78897_a;
                    }
                }
            } else {
                i = -4;
            }
            if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
                minX += Math.min(2, (maxX - minX) / 2 - 1);
                maxX -= Math.min(2, (maxX - minX) / 2 - 1);
            } else if (facing == EnumFacing.EAST || facing == EnumFacing.WEST) {
                minZ += Math.min(2, (maxZ - minZ) / 2 - 1);
                maxZ -= Math.min(2, (maxZ - minZ) / 2 - 1);
            }
            BlockPos.MutableBlockPos currentBlock = new BlockPos.MutableBlockPos();
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    int height;
                    int y = world.field_73011_w.func_76557_i() - 2;
                    if (x >= villageBoundingBox.field_78897_a && x <= villageBoundingBox.field_78893_d && z >= villageBoundingBox.field_78896_c && z <= villageBoundingBox.field_78892_f) continue;
                    StructureBoundingBox chunkBoundingBox = new StructureBoundingBox(x & 0xFFFFFFF0, z & 0xFFFFFFF0, x | 0xF, z | 0xF);
                    MuonHeightMap found = MuonHooks.findTerrain((StructureBoundingBox)villageBoundingBox, (StructureBoundingBox)chunkBoundingBox);
                    currentBlock.func_181079_c(x, y, z);
                    int n = height = found == null ? -1 : Hook.getHeight(found, x, z);
                    if (height != -1) {
                        y = Math.max(y, height);
                    } else {
                        BlockPos topBlock = MuonUtils.getTopSolidOrLiquidBlock((World)world, (BlockPos)currentBlock);
                        Block block = world.func_180495_p(topBlock).func_177230_c();
                        while (block == Blocks.field_150350_a && (topBlock = topBlock.func_177977_b()).func_177956_o() >= 0) {
                            block = world.func_180495_p(topBlock).func_177230_c();
                        }
                        y = Math.max(y, topBlock.func_177956_o());
                    }
                    i += y;
                    ++j;
                    if (minY != -1 && y >= minY) continue;
                    minY = y;
                }
            }
            if (j > 0) {
                if (i / j >= minY + 1) {
                    return minY + 1;
                }
                return i / j + 1;
            }
            return -1;
        }

        private static int getHeight(MuonHeightMap heightMap, int x, int z) {
            try {
                return (Integer)GET_HEIGHT.invoke((Object)heightMap, x, z);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                return -1;
            }
        }
    }
}

