/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.craftinggrid;

import java.awt.Rectangle;
import mcjty.lib.base.ModBase;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.typed.TypedMap;
import mcjty.rftools.craftinggrid.CraftingGridInventory;
import mcjty.rftools.craftinggrid.CraftingGridProvider;
import mcjty.rftools.craftinggrid.CraftingRecipe;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.setup.CommandHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import org.lwjgl.input.Mouse;

public class GuiCraftingGrid {
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/craftinggrid.png");
    protected Window craftWindow;
    private Button craft1Button;
    private Button craft4Button;
    private Button craft8Button;
    private Button craftSButton;
    private Minecraft mc;
    private GenericGuiContainer<?> gui;
    private CraftingGridProvider provider;
    private BlockPos pos;
    public static int[] testResultFromServer = null;
    private int lastTestAmount = -2;
    private int lastTestTimer = 0;
    private int offsetLeft = 22;
    private int offsetTop = 114;

    public GuiCraftingGrid(String up) {
        this.offsetLeft = 10;
        this.offsetTop = 35;
    }

    public GuiCraftingGrid() {
    }

    public void initGui(ModBase modBase, SimpleNetworkWrapper network, Minecraft mc, GenericGuiContainer<?> gui, BlockPos pos, CraftingGridProvider provider, int guiLeft, int guiTop, int xSize, int ySize) {
        this.mc = mc;
        this.gui = gui;
        this.provider = provider;
        this.pos = pos;
        this.craft1Button = (Button)((Button)((Button)((Button)new Button(mc, gui).setChannel("craft1")).setText("1")).setLayoutHint(29, 183, 14, 10)).setTooltips(new String[]{"Craft one"});
        this.craft4Button = (Button)((Button)((Button)((Button)new Button(mc, gui).setChannel("craft4")).setText("4")).setLayoutHint(45, 183, 14, 10)).setTooltips(new String[]{"Craft four"});
        this.craft8Button = (Button)((Button)((Button)((Button)new Button(mc, gui).setChannel("craft8")).setText("8")).setLayoutHint(29, 195, 14, 10)).setTooltips(new String[]{"Craft eight"});
        this.craftSButton = (Button)((Button)((Button)((Button)new Button(mc, gui).setChannel("craftstack")).setText("*")).setLayoutHint(45, 195, 14, 10)).setTooltips(new String[]{"Craft a stack"});
        Panel sidePanel = (Panel)new Panel(mc, gui).setLayout((Layout)new PositionalLayout()).addChildren(new Widget[]{this.craft1Button, this.craft4Button, this.craft8Button, this.craftSButton});
        int sideLeft = guiLeft + this.offsetLeft;
        int sideTop = guiTop + this.offsetTop;
        sidePanel.setBounds(new Rectangle(sideLeft, sideTop, CraftingGridInventory.GRID_WIDTH, CraftingGridInventory.GRID_HEIGHT));
        sidePanel.setBackground(iconLocation);
        this.craftWindow = new Window(gui, (AbstractContainerWidget)sidePanel);
        this.craftWindow.event("craft1", (source, params) -> this.craft(1));
        this.craftWindow.event("craft4", (source, params) -> this.craft(4));
        this.craftWindow.event("craft8", (source, params) -> this.craft(8));
        this.craftWindow.event("craftstack", (source, params) -> this.craft(-1));
    }

    public Window getWindow() {
        return this.craftWindow;
    }

    private void craft(int n) {
        RFToolsMessages.sendToServer("craftFromGrid", TypedMap.builder().put(CommandHandler.PARAM_COUNT, (Object)n).put(CommandHandler.PARAM_TEST, (Object)false).put(CommandHandler.PARAM_POS, (Object)this.pos));
    }

    private void testCraft(int n) {
        if (this.lastTestAmount != n || this.lastTestTimer <= 0) {
            RFToolsMessages.sendToServer("craftFromGrid", TypedMap.builder().put(CommandHandler.PARAM_COUNT, (Object)n).put(CommandHandler.PARAM_TEST, (Object)true).put(CommandHandler.PARAM_POS, (Object)this.pos));
            this.lastTestAmount = n;
            this.lastTestTimer = 20;
        }
        --this.lastTestTimer;
    }

    public void draw() {
        this.testRecipe();
        int x = Mouse.getEventX() * this.gui.field_146294_l / this.gui.field_146297_k.field_71443_c;
        int y = this.gui.field_146295_m - Mouse.getEventY() * this.gui.field_146295_m / this.gui.field_146297_k.field_71440_d - 1;
        Widget widget = this.craftWindow.getToplevel().getWidgetAtPosition(x, y);
        if (widget == this.craft1Button) {
            this.testCraft(1);
        } else if (widget == this.craft4Button) {
            this.testCraft(4);
        } else if (widget == this.craft8Button) {
            this.testCraft(8);
        } else if (widget == this.craftSButton) {
            this.testCraft(-1);
        } else {
            testResultFromServer = null;
            this.lastTestAmount = -2;
            this.lastTestTimer = 0;
        }
        this.craftWindow.draw();
        if (testResultFromServer != null) {
            Slot slot;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.gui.getGuiLeft(), (float)this.gui.getGuiTop(), (float)0.0f);
            if (testResultFromServer[9] > 0 && (slot = this.gui.field_147002_h.func_75147_a((IInventory)this.provider.getCraftingGrid().getCraftingGridInventory(), CraftingGridInventory.SLOT_GHOSTOUTPUT)) != null) {
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                int xPos = slot.field_75223_e;
                int yPos = slot.field_75221_f;
                Gui.func_73734_a((int)xPos, (int)yPos, (int)(xPos + 16), (int)(yPos + 16), (int)-65536);
            }
            for (int i = 0; i < 9; ++i) {
                Slot slot2;
                if (testResultFromServer[i] <= 0 || (slot2 = this.gui.field_147002_h.func_75147_a((IInventory)this.provider.getCraftingGrid().getCraftingGridInventory(), CraftingGridInventory.SLOT_GHOSTINPUT + i)) == null) continue;
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                int xPos = slot2.field_75223_e;
                int yPos = slot2.field_75221_f;
                Gui.func_73734_a((int)xPos, (int)yPos, (int)(xPos + 16), (int)(yPos + 16), (int)-65536);
            }
            GlStateManager.func_179121_F();
        }
    }

    private void testRecipe() {
        InventoryCrafting inv = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer var1) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            inv.func_70299_a(i, this.provider.getCraftingGrid().getCraftingGridInventory().func_70301_a(i + 1));
        }
        IRecipe recipe = CraftingRecipe.findRecipe((World)this.mc.field_71441_e, inv);
        ItemStack newResult = recipe == null ? ItemStack.field_190927_a : recipe.func_77572_b(inv);
        this.provider.getCraftingGrid().getCraftingGridInventory().func_70299_a(0, newResult);
    }
}

