/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storagemonitor;

import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mcjty.lib.base.ModBase;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.storagemonitor.PacketGetInventoryInfo;
import mcjty.rftools.blocks.storagemonitor.PacketReturnInventoryInfo;
import mcjty.rftools.blocks.storagemonitor.StorageScannerContainer;
import mcjty.rftools.blocks.storagemonitor.StorageScannerTileEntity;
import mcjty.rftools.craftinggrid.GuiCraftingGrid;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.setup.CommandHandler;
import mcjty.rftools.setup.GuiProxy;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;

public class GuiStorageScanner
extends GenericGuiContainer<StorageScannerTileEntity> {
    private static final int STORAGE_MONITOR_WIDTH = 256;
    private static final int STORAGE_MONITOR_HEIGHT = 244;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/storagescanner.png");
    public static List<PacketReturnInventoryInfo.InventoryInfo> fromServer_inventories = new ArrayList<PacketReturnInventoryInfo.InventoryInfo>();
    public static Set<BlockPos> fromServer_foundInventories = new HashSet<BlockPos>();
    public static List<ItemStack> fromServer_inventory = new ArrayList<ItemStack>();
    private static long lastTime = 0L;
    private final GuiCraftingGrid craftingGrid = new GuiCraftingGrid("up");
    private int listDirty = 0;
    private boolean init = false;

    public GuiStorageScanner(StorageScannerTileEntity storageScannerTileEntity, StorageScannerContainer storageScannerContainer) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)storageScannerTileEntity, (Container)storageScannerContainer, GuiProxy.GUI_MANUAL_MAIN, "stomon");
        this.field_146999_f = 256;
        this.field_147000_g = 244;
    }

    public void func_73866_w_() {
        if (!this.init) {
            RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketGetInventoryInfo(((StorageScannerTileEntity)this.tileEntity).getDimension(), ((StorageScannerTileEntity)this.tileEntity).getStorageScannerPos(), true));
        }
        super.func_73866_w_();
        Panel toplevel = ((Panel)new Panel(this.field_146297_k, (Gui)this).setBackground(iconLocation)).setLayout((Layout)new PositionalLayout());
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((GuiScreen)this, (AbstractContainerWidget)toplevel);
        this.window.event("up", (source, params) -> this.moveUp());
        this.window.event("top", (source, params) -> this.moveTop());
        this.window.event("down", (source, params) -> this.moveDown());
        this.window.event("bottom", (source, params) -> this.moveBottom());
        this.window.event("remove", (source, params) -> this.removeFromList());
        this.window.event("scan", (source, params) -> RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketGetInventoryInfo(((StorageScannerTileEntity)this.tileEntity).getDimension(), ((StorageScannerTileEntity)this.tileEntity).getStorageScannerPos(), true)));
        Keyboard.enableRepeatEvents((boolean)true);
        fromServer_foundInventories.clear();
        fromServer_inventory.clear();
        if (((StorageScannerTileEntity)this.tileEntity).isDummy()) {
            fromServer_inventories.clear();
        } else {
            ((StorageScannerTileEntity)this.tileEntity).requestRfFromServer("rftools");
        }
        BlockPos pos = ((StorageScannerTileEntity)this.tileEntity).getCraftingGridContainerPos();
        this.craftingGrid.initGui(this.modBase, this.network, this.field_146297_k, this, pos, ((StorageScannerTileEntity)this.tileEntity).getCraftingGridProvider(), this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g);
        this.sendServerCommand("rftools", "requestGridSync", TypedMap.builder().put(CommandHandler.PARAM_POS, (Object)pos).build());
        this.init = true;
    }

    protected void func_73864_a(int x, int y, int button) throws IOException {
        super.func_73864_a(x, y, button);
        this.craftingGrid.getWindow().mouseClicked(x, y, button);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.craftingGrid.getWindow().handleMouseInput();
    }

    protected void func_146286_b(int x, int y, int state) {
        super.func_146286_b(x, y, state);
        this.craftingGrid.getWindow().mouseMovedOrUp(x, y, state);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        this.craftingGrid.getWindow().keyTyped(typedChar, keyCode);
    }

    private void moveUp() {
        this.listDirty = 0;
    }

    private void moveTop() {
        this.listDirty = 0;
    }

    private void moveDown() {
        this.listDirty = 0;
    }

    private void moveBottom() {
        this.listDirty = 0;
    }

    private void removeFromList() {
        this.listDirty = 0;
    }

    private void getInventoryOnServer() {
        BlockPos c = this.getSelectedContainerPos();
        if (c != null) {
            this.sendServerCommand("rftools", "requestScannerContents", TypedMap.builder().put(CommandHandler.PARAM_SCANNER_DIM, (Object)((StorageScannerTileEntity)this.tileEntity).getDimension()).put(CommandHandler.PARAM_SCANNER_POS, (Object)((StorageScannerTileEntity)this.tileEntity).getStorageScannerPos()).put(CommandHandler.PARAM_INV_POS, (Object)c).build());
        }
    }

    private BlockPos getSelectedContainerPos() {
        return null;
    }

    private void requestListsIfNeeded() {
        --this.listDirty;
        if (this.listDirty <= 0) {
            RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketGetInventoryInfo(((StorageScannerTileEntity)this.tileEntity).getDimension(), ((StorageScannerTileEntity)this.tileEntity).getStorageScannerPos(), false));
            this.getInventoryOnServer();
            this.listDirty = 20;
        }
    }

    private void updateContentsList() {
        Collections.sort(fromServer_inventory, Comparator.comparing(ItemStack::func_82833_r));
    }

    private void updateStorageList() {
        for (PacketReturnInventoryInfo.InventoryInfo c : fromServer_inventories) {
            if (!fromServer_foundInventories.contains(c.getPos())) continue;
        }
    }

    protected void func_146976_a(float v, int i, int i2) {
        if (!this.init) {
            return;
        }
        this.updateStorageList();
        this.updateContentsList();
        this.requestListsIfNeeded();
        if (!((StorageScannerTileEntity)this.tileEntity).isDummy()) {
            ((StorageScannerTileEntity)this.tileEntity).requestRfFromServer("rftools");
        } else if (System.currentTimeMillis() - lastTime > 300L) {
            lastTime = System.currentTimeMillis();
            ((StorageScannerTileEntity)this.tileEntity).requestDataFromServer("rftools", "getScannerInfo", TypedMap.EMPTY);
        }
        this.drawWindow();
    }

    protected void func_146979_b(int i1, int i2) {
        if (!this.init) {
            return;
        }
        super.func_146979_b(i1, i2);
    }

    protected void drawStackTooltips(int mouseX, int mouseY) {
        if (this.init) {
            super.drawStackTooltips(mouseX, mouseY);
        }
    }

    protected void drawWindow() {
        if (!this.init) {
            return;
        }
        super.drawWindow();
        this.craftingGrid.draw();
    }
}

