/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.network;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import reborncore.RebornCore;
import reborncore.common.network.ExtendedPacketBuffer;

public enum ObjectBufferUtils {
    STRING(String.class, (string, buffer) -> {
        buffer.writeInt(string.length());
        buffer.func_180714_a((String)string);
    }, buffer -> buffer.func_150789_c(buffer.readInt())),
    INT(Integer.class, (value, buffer) -> buffer.writeInt((int)value), PacketBuffer::readInt),
    LONG(Long.class, (pos, buffer) -> buffer.writeLong((long)pos), PacketBuffer::readLong),
    DOUBLE(Double.class, (pos, buffer) -> buffer.writeDouble((double)pos), PacketBuffer::readDouble),
    FLOAT(Float.class, (pos, buffer) -> buffer.writeFloat(pos.floatValue()), PacketBuffer::readFloat),
    BLOCK_POS(BlockPos.class, (pos, buffer) -> buffer.func_179255_a((BlockPos)pos), PacketBuffer::func_179259_c),
    BIG_INT(BigInteger.class, (pos, buffer) -> buffer.writeBigInt((BigInteger)pos), ExtendedPacketBuffer::readBigInt),
    FLUID_STACK(FluidStack.class, (pos, buffer) -> buffer.writeFluidStack((FluidStack)pos), ExtendedPacketBuffer::readFluidStack);

    Class clazz;
    ObjectWriter writer;
    ObjectReader reader;

    private <T> ObjectBufferUtils(Class<T> clazz, ObjectWriter<T> writer, ObjectReader<T> reader) {
        this.clazz = clazz;
        this.writer = writer;
        this.reader = reader;
    }

    public static void writeObject(Object object, ExtendedPacketBuffer buffer) {
        RebornCore.logHelper.fatal(object.getClass());
        ObjectBufferUtils utils = Arrays.stream(ObjectBufferUtils.values()).filter(objectBufferUtils -> objectBufferUtils.clazz == object.getClass()).findFirst().orElse(null);
        Objects.requireNonNull(utils, "No support found for " + object.getClass());
        buffer.writeInt(utils.ordinal());
        utils.writer.write(object, buffer);
    }

    public static Object readObject(ExtendedPacketBuffer buffer) {
        ObjectBufferUtils utils = ObjectBufferUtils.values()[buffer.readInt()];
        Objects.requireNonNull(utils, "Could not find reader");
        return utils.reader.read(buffer);
    }

    private static interface ObjectReader<T> {
        public T read(ExtendedPacketBuffer var1);
    }

    private static interface ObjectWriter<T> {
        public void write(T var1, ExtendedPacketBuffer var2);
    }
}

