/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomportals.handler;

import com.therandomlabs.randomportals.api.config.PortalType;
import com.therandomlabs.randomportals.world.storage.RPOSavedData;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public final class NetherPortalFrameBreakHandler {
    private static final Map<Map.Entry<World, BlockPos>, PortalType> positions = new HashMap<Map.Entry<World, BlockPos>, PortalType>();

    @SubscribeEvent
    public static void onBlockPlace(BlockEvent.PlaceEvent event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        if (!event.getBlockSnapshot().getReplacedBlock().func_185904_a().func_76222_j() && RPOSavedData.get(world).getGeneratedNetherPortalType(pos) != null) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        positions.put(new AbstractMap.SimpleEntry<World, BlockPos>(world, pos), RPOSavedData.get(world).getGeneratedNetherPortalType(pos));
    }

    @SubscribeEvent
    public static void onBlockDrops(BlockEvent.HarvestDropsEvent event) {
        PortalType type = positions.get(new AbstractMap.SimpleEntry<World, BlockPos>(event.getWorld(), event.getPos()));
        if (type != null && !type.frame.doGeneratedFramesDrop) {
            event.getDrops().clear();
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        RPOSavedData savedData = RPOSavedData.get(event.world);
        for (Map.Entry<Map.Entry<World, BlockPos>, PortalType> entry : positions.entrySet()) {
            Map.Entry<World, BlockPos> key;
            PortalType type = entry.getValue();
            if (type == null || (key = entry.getKey()).getKey() != event.world) continue;
            savedData.removeGeneratedNetherPortalFramePos(type.toString(), key.getValue());
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            positions.clear();
        }
    }
}

