/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomportals.api.netherportal;

import com.therandomlabs.randomportals.api.config.PortalType;
import com.therandomlabs.randomportals.api.config.PortalTypes;
import com.therandomlabs.randomportals.api.frame.Frame;
import com.therandomlabs.randomportals.api.netherportal.NetherPortal;
import com.therandomlabs.randomportals.block.BlockNetherPortal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TeleportData {
    private final World world;
    private final BlockPos portalPos;
    private IBlockState portalState;
    private NetherPortal portal;
    private boolean portalChecked;

    public TeleportData(World world, BlockPos portalPos, IBlockState portalState, NetherPortal portal) {
        this.world = world;
        this.portalPos = portalPos;
        this.portalState = portalState;
        this.portal = portal;
    }

    @Nonnull
    public World getSendingPortalWorld() {
        return this.world;
    }

    @Nullable
    public Frame getFrame() {
        return this.portal == null ? null : this.portal.getFrame();
    }

    @Nullable
    public PortalType getPortalType() {
        return this.portal == null ? PortalTypes.getDefault(this.world) : this.portal.getType();
    }

    @Nonnull
    public BlockPos getPortalPos() {
        return this.portalPos;
    }

    @Nonnull
    public IBlockState getPortalState() {
        return this.portalState;
    }

    @Nullable
    public NetherPortal getPortal() {
        if (this.portal == null && !this.portalChecked) {
            Tuple<Boolean, NetherPortal> tuple = BlockNetherPortal.findFrame(this.world, this.portalPos);
            if (tuple != null) {
                this.portal = (NetherPortal)tuple.func_76340_b();
            }
            this.portalChecked = true;
        }
        return this.portal;
    }
}

