/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.repackage.com.therandomlabs.randomlib;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import net.minecraft.crash.CrashReport;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.ReportedException;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;
import net.minecraftforge.fml.relauncher.FMLInjectionData;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import org.apache.commons.lang3.ArrayUtils;

public final class TRLUtils {
    public static final boolean IS_DEOBFUSCATED = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    public static final boolean IS_CLIENT = FMLLaunchHandler.side().isClient();
    public static final String MC_VERSION = (String)FMLInjectionData.data()[4];
    public static final int MC_VERSION_NUMBER = Integer.parseInt(MC_VERSION.split("\\.")[1]);
    public static final ArtifactVersion MC_ARTIFACT_VERSION = new DefaultArtifactVersion("minecraft", MC_VERSION);
    private static Field modifiers;

    private TRLUtils() {
    }

    public static String localize(String key, Object ... args) {
        return I18n.func_74837_a((String)key, (Object[])args);
    }

    public static Object toPrimitiveArray(Object[] boxedArray) {
        if (boxedArray instanceof Boolean[]) {
            return ArrayUtils.toPrimitive((Boolean[])((Boolean[])boxedArray));
        }
        if (boxedArray instanceof Byte[]) {
            return ArrayUtils.toPrimitive((Byte[])((Byte[])boxedArray));
        }
        if (boxedArray instanceof Character[]) {
            return ArrayUtils.toPrimitive((Character[])((Character[])boxedArray));
        }
        if (boxedArray instanceof Double[]) {
            return ArrayUtils.toPrimitive((Double[])((Double[])boxedArray));
        }
        if (boxedArray instanceof Float[]) {
            return ArrayUtils.toPrimitive((Float[])((Float[])boxedArray));
        }
        if (boxedArray instanceof Integer[]) {
            return ArrayUtils.toPrimitive((Integer[])((Integer[])boxedArray));
        }
        if (boxedArray instanceof Long[]) {
            return ArrayUtils.toPrimitive((Long[])((Long[])boxedArray));
        }
        if (boxedArray instanceof Short[]) {
            return ArrayUtils.toPrimitive((Short[])((Short[])boxedArray));
        }
        return boxedArray;
    }

    public static Object[] toBoxedArray(Object primitiveArray) {
        if (primitiveArray instanceof Object[]) {
            return (Object[])primitiveArray;
        }
        if (primitiveArray instanceof boolean[]) {
            return ArrayUtils.toObject((byte[])((byte[])primitiveArray));
        }
        if (primitiveArray instanceof byte[]) {
            return ArrayUtils.toObject((byte[])((byte[])primitiveArray));
        }
        if (primitiveArray instanceof char[]) {
            return ArrayUtils.toObject((char[])((char[])primitiveArray));
        }
        if (primitiveArray instanceof double[]) {
            return ArrayUtils.toObject((double[])((double[])primitiveArray));
        }
        if (primitiveArray instanceof float[]) {
            return ArrayUtils.toObject((float[])((float[])primitiveArray));
        }
        if (primitiveArray instanceof int[]) {
            return ArrayUtils.toObject((int[])((int[])primitiveArray));
        }
        if (primitiveArray instanceof long[]) {
            return ArrayUtils.toObject((long[])((long[])primitiveArray));
        }
        if (primitiveArray instanceof short[]) {
            return ArrayUtils.toObject((long[])((long[])primitiveArray));
        }
        return null;
    }

    public static Path getPath(String path) {
        try {
            return Paths.get(path, new String[0]).normalize();
        }
        catch (InvalidPathException invalidPathException) {
            return null;
        }
    }

    public static String toStringWithUnixPathSeparators(Path path) {
        return path.toString().replace('\\', '/');
    }

    public static Field findField(Class<?> clazz, String ... names) {
        for (Field field : clazz.getDeclaredFields()) {
            for (String name : names) {
                if (!name.equals(field.getName())) continue;
                field.setAccessible(true);
                return field;
            }
        }
        return null;
    }

    public static Method findMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        return TRLUtils.findMethod(clazz, name, name, parameterTypes);
    }

    public static Method findMethod(Class<?> clazz, String name, String obfName, Class<?> ... parameterTypes) {
        for (Method method : clazz.getDeclaredMethods()) {
            String methodName = method.getName();
            if (!name.equals(methodName) && !obfName.equals(methodName) || !Arrays.equals(method.getParameterTypes(), parameterTypes)) continue;
            method.setAccessible(true);
            return method;
        }
        return null;
    }

    public static Field removeFinalModifier(Field field) {
        try {
            if (modifiers == null) {
                modifiers = Field.class.getDeclaredField("modifiers");
                modifiers.setAccessible(true);
            }
            modifiers.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        }
        catch (Exception ex) {
            TRLUtils.crashReport("Failed to make " + field.getName() + " non-final", ex);
        }
        return field;
    }

    public static Class<?> getClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static void crashReport(String message, Throwable throwable) {
        throw new ReportedException(new CrashReport(message, throwable));
    }
}

