/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3i;

public enum Diagonal {
    NW(EnumFacing.NORTH, EnumFacing.WEST),
    NE(EnumFacing.NORTH, EnumFacing.EAST),
    SW(EnumFacing.SOUTH, EnumFacing.WEST),
    SE(EnumFacing.SOUTH, EnumFacing.EAST);

    public final int offsetX;
    public final int offsetY;
    public final int offsetZ;
    private static final Map<Diagonal, Diagonal> OPPOSITES;
    private static final Map<Diagonal, Diagonal> CW;
    private static final Map<Diagonal, Diagonal> CCW;
    public static final Diagonal[] VALUES;

    private Diagonal(EnumFacing a, EnumFacing b) {
        Vec3i va = a.func_176730_m();
        Vec3i vb = b.func_176730_m();
        this.offsetX = va.func_177958_n() + vb.func_177958_n();
        this.offsetY = va.func_177956_o() + vb.func_177956_o();
        this.offsetZ = va.func_177952_p() + vb.func_177952_p();
    }

    public Diagonal getOpposite() {
        return OPPOSITES.get((Object)this);
    }

    public Diagonal rotateCW() {
        return CW.get((Object)this);
    }

    public Diagonal rotateCCW() {
        return CCW.get((Object)this);
    }

    static {
        OPPOSITES = Maps.newEnumMap(Diagonal.class);
        CW = Maps.newEnumMap(Diagonal.class);
        CCW = Maps.newEnumMap(Diagonal.class);
        OPPOSITES.put(NW, SE);
        OPPOSITES.put(SE, NW);
        OPPOSITES.put(NE, SW);
        OPPOSITES.put(SW, NE);
        CW.put(NW, SW);
        CW.put(SW, SE);
        CW.put(SE, NE);
        CW.put(NE, NW);
        CCW.put(NW, NE);
        CCW.put(NE, SE);
        CCW.put(SE, SW);
        CCW.put(SW, NW);
        VALUES = Diagonal.values();
    }
}

