/*
 * Decompiled with CFR 0.152.
 */
package openmods.sync;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import openmods.sync.ISyncableObject;
import openmods.sync.ISyncableValueProvider;
import openmods.sync.SyncableObjectBase;

public class SyncableEnum<E extends Enum<E>>
extends SyncableObjectBase
implements ISyncableValueProvider<E> {
    public static final Supplier<ISyncableObject> DUMMY_SUPPLIER = () -> new SyncableObjectBase(){

        @Override
        public void writeToStream(PacketBuffer buf) {
            buf.func_150787_b(0);
        }

        @Override
        public void readFromStream(PacketBuffer buf) {
            buf.func_150792_a();
        }

        @Override
        public void writeToNBT(NBTTagCompound nbt, String name) {
        }

        @Override
        public void readFromNBT(NBTTagCompound nbt, String name) {
        }
    };
    private final E[] values;
    private E value;

    public static <E extends Enum<E>> SyncableEnum<E> create(E initialValue) {
        return new SyncableEnum<E>(initialValue);
    }

    public SyncableEnum(E value) {
        this.value = value;
        this.values = (Enum[])((Enum)value).getDeclaringClass().getEnumConstants();
    }

    @Override
    public void readFromStream(PacketBuffer stream) {
        int ordinal = stream.func_150792_a();
        this.value = this.values[ordinal];
    }

    @Override
    public void writeToStream(PacketBuffer stream) {
        stream.func_150787_b(((Enum)this.value).ordinal());
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String name) {
        nbt.func_74768_a(name, ((Enum)this.value).ordinal());
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String name) {
        int original = nbt.func_74762_e(name);
        this.value = this.values[original];
    }

    @Override
    public E getValue() {
        return this.value;
    }

    public E get() {
        return this.value;
    }

    public void set(E value) {
        Preconditions.checkNotNull(value);
        if (this.value != value) {
            this.value = value;
            this.markDirty();
        }
    }

    public E increment() {
        int next = ((Enum)this.value).ordinal() + 1;
        this.value = next >= this.values.length ? this.values[0] : this.values[next];
        this.markDirty();
        return this.value;
    }

    public E decrement() {
        int prev = ((Enum)this.value).ordinal() - 1;
        this.value = prev < 0 ? this.values[this.values.length - 1] : this.values[prev];
        this.markDirty();
        return this.value;
    }
}

