/*
 * Decompiled with CFR 0.152.
 */
package openmods.state;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Table;
import java.util.Locale;
import java.util.Map;
import net.minecraft.block.properties.IProperty;

public class State {
    private final Map<IProperty<?>, Comparable<?>> values;
    private Table<IProperty<?>, Comparable<?>, State> neighbours;
    private final String variant;

    private static <T extends Comparable<T>> Function<Map.Entry<IProperty<?>, Comparable<?>>, String> createConverter() {
        return entry -> {
            IProperty property = (IProperty)entry.getKey();
            Comparable value = (Comparable)entry.getValue();
            return property.func_177701_a() + "=" + property.func_177702_a(value);
        };
    }

    State(Map<IProperty<?>, Comparable<?>> values) {
        this.values = ImmutableMap.copyOf(values);
        StringBuilder variantBuilder = new StringBuilder();
        Joiner.on((char)',').appendTo(variantBuilder, Iterables.transform(values.entrySet(), State.createConverter()));
        this.variant = variantBuilder.toString().toLowerCase(Locale.ROOT);
    }

    public <T extends Comparable<T>> T getValue(IProperty<T> property) {
        Comparable<?> value = this.values.get(property);
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"Cannot get property %s", property);
        return (T)((Comparable)property.func_177699_b().cast(value));
    }

    public <T extends Comparable<T>, V extends T> State withProperty(IProperty<T> property, V newValue) {
        Comparable<?> value = this.values.get(property);
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"Cannot set property %s", property);
        if (newValue == value) {
            return this;
        }
        State newState = (State)this.neighbours.get(property, newValue);
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"Cannot set property %s to value %s", property, newValue);
        return newState;
    }

    public String getVariant() {
        return this.variant;
    }

    void updateNeighbours(Map<Map<IProperty<?>, Comparable<?>>, State> valuesToStateMap) {
        Preconditions.checkState((this.neighbours == null ? 1 : 0) != 0);
        HashBasedTable neighbours = HashBasedTable.create();
        for (Map.Entry<IProperty<?>, Comparable<?>> e : this.values.entrySet()) {
            IProperty<?> property = e.getKey();
            Comparable<?> currentValue = e.getValue();
            for (Comparable value : property.func_177700_c()) {
                if (value == currentValue) continue;
                neighbours.put(property, (Object)value, (Object)valuesToStateMap.get(this.updateSingleValue(property, value)));
            }
        }
        this.neighbours = ImmutableTable.copyOf((Table)neighbours);
    }

    private Map<IProperty<?>, Comparable<?>> updateSingleValue(IProperty<?> key, Comparable<?> value) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (Map.Entry<IProperty<?>, Comparable<?>> e : this.values.entrySet()) {
            if (e.getKey() == key) {
                result.put(key, value);
                continue;
            }
            result.put(e);
        }
        return result.build();
    }

    public String toString() {
        return "State[" + this.variant + "]";
    }
}

