/*
 * Decompiled with CFR 0.152.
 */
package openmods.source;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.SyntaxErrorException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import openmods.Log;
import openmods.source.ClassSourceCollector;
import openmods.utils.CommandUtils;
import openmods.utils.SidedCommand;

public class CommandSource
extends SidedCommand {
    private static final String COMMAND_CLASS = "class";
    private final List<String> subcommands = ImmutableList.of((Object)"class");
    private final ClassSourceCollector classMeta;

    public CommandSource(String name, boolean restricted, ClassSourceCollector classMeta) {
        super(name, restricted);
        this.classMeta = classMeta;
    }

    public String func_71518_a(ICommandSender icommandsender) {
        return this.name + " class <class name>";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) {
            throw new SyntaxErrorException();
        }
        String subCommand = args[0];
        if (subCommand.equals(COMMAND_CLASS)) {
            if (args.length < 2) {
                throw new SyntaxErrorException();
            }
            String clsName = args[1];
            ClassSourceCollector.ClassMeta meta = this.getMeta(clsName);
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("openmodslib.command.class_source", new Object[]{meta.cls.getName(), meta.source()}));
            ClassSourceCollector.ApiInfo api = meta.api;
            if (api != null) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("openmodslib.command.api_class", new Object[]{api.api, api.owner, api.version}));
            }
            for (Map.Entry<File, Set<String>> e : meta.providerMods.entrySet()) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("openmodslib.command.class_provider", new Object[]{e.getKey().getAbsolutePath(), Joiner.on((char)',').join((Iterable)e.getValue())}));
            }
        }
    }

    private ClassSourceCollector.ClassMeta getMeta(String clsName) throws CommandException {
        try {
            return this.classMeta.getClassInfo(clsName);
        }
        catch (ClassNotFoundException e) {
            throw new CommandException("openmodslib.command.invalid_class_name", new Object[]{clsName});
        }
        catch (Throwable t) {
            Log.warn(t, "Failed to get information for class %s", clsName);
            throw new CommandException("openmodslib.command.unknown_error_details", new Object[0]);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return CommandUtils.filterPrefixes(args[0], this.subcommands);
        }
        return Collections.emptyList();
    }

    public boolean func_82358_a(String[] astring, int i) {
        return false;
    }
}

