/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import openblocks.OpenBlocks;
import openblocks.common.MapDataManager;
import openmods.utils.ItemUtils;

public class ItemEmptyMap
extends Item {
    public static final String TAG_SCALE = "Scale";
    public static final int MAX_SCALE = 4;

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, List<String> result, ITooltipFlag flag) {
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
        result.add(String.format("Scale: 1:%d", 1 << tag.func_74771_c(TAG_SCALE)));
    }

    @Nonnull
    public static ItemStack createMap(Item item, int scale) {
        ItemStack result = new ItemStack(item);
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)result);
        tag.func_74774_a(TAG_SCALE, (byte)scale);
        return result;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> result) {
        if (this.func_194125_a(tab)) {
            for (int scale = 0; scale < 4; ++scale) {
                result.add((Object)ItemEmptyMap.createMap(this, scale));
            }
        }
    }

    @Nonnull
    public static ItemStack upgradeToMap(World world, ItemStack emptyMap) {
        if (OpenBlocks.Items.heightMap == null) {
            return emptyMap;
        }
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)emptyMap);
        byte scale = tag.func_74771_c(TAG_SCALE);
        int newMapId = MapDataManager.createNewMap(world, scale);
        return new ItemStack(OpenBlocks.Items.heightMap, 1, newMapId);
    }
}

