/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.immersivetech;

import com.blamejared.ModTweaker;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.utils.BaseAction;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.liquid.ILiquidStack;
import ferro2000.immersivetech.api.craftings.SolarTowerRecipes;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.immersivetech.SolarTower")
@ZenRegister
@ModOnly(value="immersivetech")
public class SolarTower {
    @ZenMethod
    public static void addRecipe(ILiquidStack output, ILiquidStack input, int time) {
        if (input.getAmount() > 1000) {
            throw new IllegalArgumentException("Cannot have a fluid input amount greater than 1000 mb, or else the Solar Tower won't accept the liquid!");
        }
        ModTweaker.LATE_ADDITIONS.add((IAction)new Add(InputHelper.toFluid((ILiquidStack)output), InputHelper.toFluid((ILiquidStack)input), time));
    }

    @ZenMethod
    public static void removeRecipe(ILiquidStack input) {
        ModTweaker.LATE_REMOVALS.add((IAction)new Remove(InputHelper.toFluid((ILiquidStack)input)));
    }

    private static class Remove
    extends BaseAction {
        private FluidStack input;

        public Remove(FluidStack input) {
            super("SolarTower");
            this.input = input.copy();
            this.input.amount = Integer.MAX_VALUE;
        }

        public void apply() {
            SolarTowerRecipes.recipeList.remove(SolarTowerRecipes.findRecipe((FluidStack)this.input));
        }

        public String describe() {
            return "Removing Solar Tower recipe for: " + this.input;
        }
    }

    private static class Add
    extends BaseAction {
        private FluidStack output;
        private FluidStack input;
        private int time;

        public Add(FluidStack output, FluidStack input, int time) {
            super("SolarTower");
            this.output = output;
            this.input = input;
            this.time = time;
        }

        public void apply() {
            SolarTowerRecipes.addRecipe((FluidStack)this.output, (FluidStack)this.input, (int)this.time);
        }

        public String describe() {
            return "Adding Solar Tower recipe for: " + this.output + " from: " + this.input + " time: " + this.time;
        }
    }
}

