/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile;

import crazypants.enderio.base.conduit.ConnectionMode;
import crazypants.enderio.conduits.conduit.TileConduitBundle;
import crazypants.enderio.conduits.conduit.power.PowerConduit;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.api.IHeatTransfer;
import mekanism.api.TileNetworkList;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.common.base.FluidHandlerWrapper;
import mekanism.common.base.IComparatorSupport;
import mekanism.common.base.IFluidHandlerWrapper;
import mekanism.common.base.ISustainedData;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.tile.TileEntityThermalEvaporationController;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.HeatUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.PipeUtils;
import mekanism.common.util.TileUtils;
import mekanism.generators.common.tile.TileEntityGenerator;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityHeatGenerator8
extends TileEntityGenerator
implements IFluidHandlerWrapper,
ISustainedData,
IHeatTransfer,
IComparatorSupport {
    private static final String[] methods = new String[]{"getEnergy", "getOutput", "getMaxEnergy", "getEnergyNeeded", "getFuel", "getFuelNeeded"};
    public FluidTank lavaTank = new FluidTank(24000);
    public int multi = 8;
    public double temperature = 0.0;
    public double thermalEfficiency = 0.5 * (double)this.multi;
    public double invHeatCapacity = 1.0;
    public double heatToAbsorb = 0.0;
    public double producingEnergy;
    public double lastTransferLoss;
    public double lastEnvironmentLoss;
    private int currentRedstoneLevel;
    public Coord4D master;

    public TileEntityHeatGenerator8() {
        super("heat", "HeatGenerator", 160000.0, 160000.0);
        this.inventory = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            ChargeUtils.charge((int)1, (IStrictEnergyStorage)this);
            this.setConduitOutput();
            this.setEnergy(this.getEnergy() + this.getBoost());
            this.producingEnergy = this.getBoost();
            int newRedstoneLevel = this.getRedstoneLevel();
            if (newRedstoneLevel != this.currentRedstoneLevel) {
                this.field_145850_b.func_175666_e(this.field_174879_c, this.func_145838_q());
                this.currentRedstoneLevel = newRedstoneLevel;
            }
        }
    }

    public void addToStructure(Coord4D controller) {
        this.master = controller;
    }

    public boolean func_94041_b(int slotID, @Nonnull ItemStack itemstack) {
        if (slotID == 0) {
            return false;
        }
        if (slotID == 1) {
            return ChargeUtils.canBeCharged((ItemStack)itemstack);
        }
        return true;
    }

    @Override
    public boolean canOperate() {
        return this.electricityStored < this.BASE_MAX_ENERGY && this.lavaTank.getFluid() != null && this.lavaTank.getFluid().amount >= 10 && MekanismUtils.canFunction((TileEntity)this);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        if (nbtTags.func_74764_b("lavaTank")) {
            this.lavaTank.readFromNBT(nbtTags.func_74775_l("lavaTank"));
        }
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        if (this.lavaTank.getFluid() != null) {
            nbtTags.func_74782_a("lavaTank", (NBTBase)this.lavaTank.writeToNBT(new NBTTagCompound()));
        }
        return nbtTags;
    }

    public boolean func_180461_b(int slotID, @Nonnull ItemStack itemstack, @Nonnull EnumFacing side) {
        if (slotID == 1) {
            return ChargeUtils.canBeOutputted((ItemStack)itemstack, (boolean)true);
        }
        if (slotID == 0) {
            return FluidUtil.getFluidContained((ItemStack)itemstack) == null;
        }
        return false;
    }

    public void setConduitOutput() {
        for (EnumFacing side : EnumFacing.field_82609_l) {
            TileConduitBundle bundle;
            PowerConduit powerConduit;
            BlockPos neighbourPos = this.field_174879_c.func_177972_a(side);
            TileEntity te = this.field_145850_b.func_175625_s(neighbourPos);
            if (!(te instanceof TileConduitBundle) || (powerConduit = (PowerConduit)(bundle = (TileConduitBundle)te).getConduit(PowerConduit.class)) == null) continue;
            EnumFacing conduitFace = side.func_176734_d();
            powerConduit.setConnectionMode(conduitFace, ConnectionMode.INPUT);
        }
    }

    public double getBoost() {
        if (this.field_145850_b.field_73011_w.getDimension() == -1) {
            return 50 * this.multi;
        }
        int lavaBoost = 0;
        for (EnumFacing side : EnumFacing.field_82609_l) {
            Coord4D coord = Coord4D.get((TileEntity)this).offset(side);
            if (!this.isLava(coord.getPos())) continue;
            ++lavaBoost;
        }
        return 0.75 * (double)this.multi * (double)lavaBoost;
    }

    private boolean isLava(BlockPos pos) {
        return this.field_145850_b.func_180495_p(pos).func_177230_c() == Blocks.field_150353_l;
    }

    public int getFuel(ItemStack itemstack) {
        return TileEntityFurnace.func_145952_a((ItemStack)itemstack) / 2;
    }

    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        int[] nArray;
        if (side == MekanismUtils.getRight((EnumFacing)this.facing)) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 1;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 0;
        }
        return nArray;
    }

    public int getScaledFuelLevel(int i) {
        return (this.lavaTank.getFluid() != null ? this.lavaTank.getFluid().amount : 0) * i / this.lavaTank.getCapacity();
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.producingEnergy = dataStream.readDouble();
            this.lastTransferLoss = dataStream.readDouble();
            this.lastEnvironmentLoss = dataStream.readDouble();
            TileUtils.readTankData((ByteBuf)dataStream, (FluidTank)this.lavaTank);
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add((Object)this.producingEnergy);
        data.add((Object)this.lastTransferLoss);
        data.add((Object)this.lastEnvironmentLoss);
        TileUtils.addTankData((TileNetworkList)data, (FluidTank)this.lavaTank);
        return data;
    }

    public String[] getMethods() {
        return methods;
    }

    public Object[] invoke(int method, Object[] arguments) throws NoSuchMethodException {
        switch (method) {
            case 0: {
                return new Object[]{this.electricityStored};
            }
            case 1: {
                return new Object[]{this.output};
            }
            case 2: {
                return new Object[]{this.BASE_MAX_ENERGY};
            }
            case 3: {
                return new Object[]{this.BASE_MAX_ENERGY - this.electricityStored};
            }
            case 4: {
                return new Object[]{this.lavaTank.getFluid() != null ? this.lavaTank.getFluid().amount : 0};
            }
            case 5: {
                return new Object[]{this.lavaTank.getCapacity() - (this.lavaTank.getFluid() != null ? this.lavaTank.getFluid().amount : 0)};
            }
        }
        throw new NoSuchMethodException();
    }

    public int fill(EnumFacing from, @Nonnull FluidStack resource, boolean doFill) {
        return 0;
    }

    @Override
    public boolean sideIsOutput(EnumFacing side) {
        return !(MekanismUtils.getTileEntitySafe((IBlockAccess)this.field_145850_b, (BlockPos)this.field_174879_c.func_177979_c(1)) instanceof TileEntityThermalEvaporationController);
    }

    public boolean canFill(EnumFacing from, @Nonnull FluidStack fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        if (from == this.facing) {
            return PipeUtils.EMPTY;
        }
        return new FluidTankInfo[]{this.lavaTank.getInfo()};
    }

    public FluidTankInfo[] getAllTanks() {
        return this.getTankInfo(null);
    }

    public void writeSustainedData(ItemStack itemStack) {
        if (this.lavaTank.getFluid() != null) {
            ItemDataUtils.setCompound((ItemStack)itemStack, (String)"lavaTank", (NBTTagCompound)this.lavaTank.getFluid().writeToNBT(new NBTTagCompound()));
        }
    }

    public void readSustainedData(ItemStack itemStack) {
        this.lavaTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)ItemDataUtils.getCompound((ItemStack)itemStack, (String)"lavaTank")));
    }

    public double getTemp() {
        return this.temperature;
    }

    public double getInverseConductionCoefficient() {
        return 1.0;
    }

    public double getInsulationCoefficient(EnumFacing side) {
        return this.canConnectHeat(side) ? 0.0 : 10000.0;
    }

    public void transferHeatTo(double heat) {
        this.heatToAbsorb += heat;
    }

    public double[] simulateHeat() {
        if (this.getTemp() > 0.0) {
            double carnotEfficiency = this.getTemp() / (this.getTemp() + 300.0);
            double heatLost = this.thermalEfficiency * this.getTemp();
            double workDone = heatLost * carnotEfficiency;
            this.transferHeatTo(-heatLost);
            this.setEnergy(this.getEnergy() + workDone);
        }
        return HeatUtils.simulate((IHeatTransfer)this);
    }

    public double applyTemperatureChange() {
        this.temperature += this.invHeatCapacity * this.heatToAbsorb;
        this.heatToAbsorb = 0.0;
        return this.temperature;
    }

    public boolean canConnectHeat(EnumFacing side) {
        return false;
    }

    public IHeatTransfer getAdjacent(EnumFacing side) {
        return null;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        return capability == Capabilities.HEAT_TRANSFER_CAPABILITY || side != this.facing && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (capability == Capabilities.HEAT_TRANSFER_CAPABILITY) {
            return (T)Capabilities.HEAT_TRANSFER_CAPABILITY.cast((Object)this);
        }
        if (side != this.facing && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new FluidHandlerWrapper((IFluidHandlerWrapper)this, side));
        }
        return (T)super.getCapability(capability, side);
    }

    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents((double)this.lavaTank.getFluidAmount(), (double)this.lavaTank.getCapacity());
    }
}

