/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.tesla;

import mekanism.api.energy.IEnergizedItem;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.integration.tesla.TeslaIntegration;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.ITeslaProducer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="net.darkhax.tesla.api.ITeslaConsumer", modid="tesla"), @Optional.Interface(iface="net.darkhax.tesla.api.ITeslaProducer", modid="tesla"), @Optional.Interface(iface="net.darkhax.tesla.api.ITeslaHolder", modid="tesla")})
public class TeslaItemWrapper
extends ItemCapabilityWrapper.ItemCapability
implements ITeslaHolder,
ITeslaConsumer,
ITeslaProducer {
    @Override
    public boolean canProcess(Capability<?> capability) {
        return capability == Capabilities.TESLA_HOLDER_CAPABILITY || capability == Capabilities.TESLA_CONSUMER_CAPABILITY && this.getItem().canReceive(this.getStack()) || capability == Capabilities.TESLA_PRODUCER_CAPABILITY && this.getItem().canSend(this.getStack());
    }

    public IEnergizedItem getItem() {
        return (IEnergizedItem)this.getStack().func_77973_b();
    }

    @Optional.Method(modid="tesla")
    public long takePower(long power, boolean simulate) {
        if (this.getItem().canSend(this.getStack())) {
            long energyRemaining = this.getStoredPower();
            long toSend = Math.min(power, energyRemaining);
            if (!simulate) {
                this.getItem().setEnergy(this.getStack(), this.getItem().getEnergy(this.getStack()) - TeslaIntegration.fromTesla(toSend));
            }
            return toSend;
        }
        return 0L;
    }

    @Optional.Method(modid="tesla")
    public long givePower(long power, boolean simulate) {
        if (this.getItem().canReceive(this.getStack())) {
            long energyNeeded = this.getCapacity() - this.getStoredPower();
            long toReceive = Math.min(power, energyNeeded);
            if (!simulate) {
                this.getItem().setEnergy(this.getStack(), this.getItem().getEnergy(this.getStack()) + TeslaIntegration.fromTesla(toReceive));
            }
            return toReceive;
        }
        return 0L;
    }

    @Optional.Method(modid="tesla")
    public long getStoredPower() {
        return TeslaIntegration.toTesla(this.getItem().getEnergy(this.getStack()));
    }

    @Optional.Method(modid="tesla")
    public long getCapacity() {
        return TeslaIntegration.toTesla(this.getItem().getMaxEnergy(this.getStack()));
    }
}

