/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.voice;

import java.io.EOFException;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import mekanism.client.voice.VoiceClient;
import mekanism.common.Mekanism;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class VoiceOutput
extends Thread {
    private final VoiceClient voiceClient;
    private final DataLine.Info speaker;
    private SourceDataLine sourceLine;

    public VoiceOutput(VoiceClient client) {
        this.voiceClient = client;
        this.speaker = new DataLine.Info(SourceDataLine.class, this.voiceClient.getAudioFormat(), 2200);
        this.setDaemon(true);
        this.setName("VoiceServer Client Output Thread");
    }

    @Override
    public void run() {
        try {
            this.sourceLine = (SourceDataLine)AudioSystem.getLine(this.speaker);
            this.sourceLine.open(this.voiceClient.getAudioFormat(), 2200);
            this.sourceLine.start();
            byte[] audioData = new byte[4096];
            while (this.voiceClient.isRunning()) {
                try {
                    if (this.voiceClient.getInputStream().available() > 0) {
                        int length;
                        for (int byteCount = this.voiceClient.getInputStream().readUnsignedShort(); byteCount > 0 && this.voiceClient.isRunning(); byteCount -= length) {
                            length = audioData.length;
                            if (length > byteCount) {
                                length = byteCount;
                            }
                            if ((length = this.voiceClient.getInputStream().read(audioData, 0, length)) < 0) {
                                throw new EOFException();
                            }
                            this.sourceLine.write(audioData, 0, length);
                        }
                        continue;
                    }
                    Thread.sleep(20L);
                }
                catch (EOFException eof) {
                    Mekanism.logger.error("VoiceServer: Unexpected input EOF Exception occurred.");
                    break;
                }
                catch (InterruptedException e) {
                    break;
                }
                catch (Exception e) {
                    Mekanism.logger.error((Object)e);
                }
            }
        }
        catch (Exception e) {
            Mekanism.logger.error("VoiceServer: Error while running client output thread.", (Throwable)e);
        }
    }

    public void close() {
        this.sourceLine.flush();
        this.sourceLine.close();
    }
}

