/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.obj;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mekanism.client.render.obj.GlowPanelModel;
import mekanism.client.render.obj.TransmitterModel;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.model.IModelState;

public class MekanismOBJModel
extends OBJModel {
    private final OBJModelType modelType;
    private final ResourceLocation location;

    public MekanismOBJModel(OBJModelType type, OBJModel.MaterialLibrary matLib, ResourceLocation modelLocation) {
        super(matLib, modelLocation);
        this.modelType = type;
        this.location = modelLocation;
    }

    @Nonnull
    public IBakedModel bake(@Nonnull IModelState state, @Nonnull VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        IBakedModel preBaked = super.bake(state, format, bakedTextureGetter);
        if (this.modelType == OBJModelType.GLOW_PANEL) {
            return new GlowPanelModel(preBaked, this, state, format, GlowPanelModel.getTexturesForOBJModel(preBaked), null);
        }
        if (this.modelType == OBJModelType.TRANSMITTER) {
            return new TransmitterModel(preBaked, this, state, format, TransmitterModel.getTexturesForOBJModel(preBaked), null);
        }
        return preBaked;
    }

    @Nonnull
    public IModel process(@Nonnull ImmutableMap<String, String> customData) {
        return new MekanismOBJModel(this.modelType, this.getMatLib(), this.location);
    }

    @Nonnull
    public IModel retexture(@Nonnull ImmutableMap<String, String> textures) {
        return new MekanismOBJModel(this.modelType, this.getMatLib().makeLibWithReplacements(textures), this.location);
    }

    @Nonnull
    public Collection<ResourceLocation> getTextures() {
        return super.getTextures().stream().filter(r -> !r.func_110623_a().startsWith("#")).collect(Collectors.toList());
    }

    public static enum OBJModelType {
        GLOW_PANEL,
        TRANSMITTER;

    }
}

