/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiProgress;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.gui.element.tab.GuiSecurityTab;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.ContainerOredictionificator;
import mekanism.common.network.PacketOredictionificatorGui;
import mekanism.common.tile.TileEntityOredictionificator;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

@SideOnly(value=Side.CLIENT)
public class GuiOredictionificator
extends GuiMekanismTile<TileEntityOredictionificator> {
    private final Map<TileEntityOredictionificator.OredictionificatorFilter, ItemStack> renderStacks = new HashMap<TileEntityOredictionificator.OredictionificatorFilter, ItemStack>();
    private boolean isDragging = false;
    private int dragOffset = 0;
    private float scroll;

    public GuiOredictionificator(InventoryPlayer inventory, TileEntityOredictionificator tile) {
        super(tile, new ContainerOredictionificator(inventory, tile));
        ResourceLocation resource = this.getGuiLocation();
        this.addGuiElement(new GuiRedstoneControl(this, this.tileEntity, resource));
        this.addGuiElement(new GuiSecurityTab((IGuiWrapper)this, this.tileEntity, resource));
        this.addGuiElement(new GuiProgress(new GuiProgress.IProgressInfoHandler(){

            @Override
            public double getProgress() {
                return ((TileEntityOredictionificator)GuiOredictionificator.this.tileEntity).didProcess ? 1.0 : 0.0;
            }
        }, GuiProgress.ProgressBar.LARGE_RIGHT, this, resource, 62, 118));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.NORMAL, this, resource, 25, 114));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.NORMAL, this, resource, 133, 114));
        this.field_147000_g += 64;
    }

    private boolean overFilter(int xAxis, int yAxis, int yStart) {
        return xAxis > 10 && xAxis <= 152 && yAxis > yStart && yAxis <= yStart + 22;
    }

    private int getScroll() {
        return Math.max(Math.min((int)(this.scroll * 73.0f), 73), 0);
    }

    private int getFilterIndex() {
        return ((TileEntityOredictionificator)this.tileEntity).filters.size() <= 3 ? 0 : (int)((float)((TileEntityOredictionificator)this.tileEntity).filters.size() * this.scroll - 3.0f / (float)((TileEntityOredictionificator)this.tileEntity).filters.size() * this.scroll);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButton(0, this.field_147003_i + 10, this.field_147009_r + 86, 142, 20, LangUtils.localize("gui.newFilter")));
    }

    protected void func_146284_a(GuiButton guibutton) throws IOException {
        super.func_146284_a(guibutton);
        if (guibutton.field_146127_k == 0) {
            Mekanism.packetHandler.sendToServer(new PacketOredictionificatorGui.OredictionificatorGuiMessage(PacketOredictionificatorGui.OredictionificatorGuiPacket.SERVER, Coord4D.get(this.tileEntity), 1, 0, 0));
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(((TileEntityOredictionificator)this.tileEntity).func_70005_c_(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(((TileEntityOredictionificator)this.tileEntity).func_70005_c_()) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, this.field_147000_g - 96 + 2, 0x404040);
        for (int i = 0; i < 3; ++i) {
            if (((TileEntityOredictionificator)this.tileEntity).filters.get(this.getFilterIndex() + i) == null) continue;
            TileEntityOredictionificator.OredictionificatorFilter filter = ((TileEntityOredictionificator)this.tileEntity).filters.get(this.getFilterIndex() + i);
            if (!this.renderStacks.containsKey(filter)) {
                this.updateRenderStacks();
            }
            int yStart = i * 22 + 18;
            this.renderItem(this.renderStacks.get(filter), 13, yStart + 3);
            this.field_146289_q.func_78276_b(LangUtils.localize("gui.filter"), 32, yStart + 2, 0x404040);
            this.renderScaledText(filter.filter, 32, yStart + 2 + 9, 0x404040, 117);
        }
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(int xAxis, int yAxis) {
        super.drawGuiContainerBackgroundLayer(xAxis, yAxis);
        this.func_73729_b(this.field_147003_i + 154, this.field_147009_r + 18 + this.getScroll(), 232, 0, 12, 15);
        for (int i = 0; i < 3; ++i) {
            if (((TileEntityOredictionificator)this.tileEntity).filters.get(this.getFilterIndex() + i) == null) continue;
            int yStart = i * 22 + 18;
            boolean mouseOver = this.overFilter(xAxis, yAxis, yStart);
            if (mouseOver) {
                MekanismRenderer.color(EnumColor.GREY);
            }
            this.func_73729_b(this.field_147003_i + 10, this.field_147009_r + yStart, 0, 230, 142, 22);
            if (!mouseOver) continue;
            MekanismRenderer.resetColor();
        }
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        super.func_73864_a(mouseX, mouseY, button);
        if (button == 0) {
            int xAxis = mouseX - this.field_147003_i;
            int yAxis = mouseY - this.field_147009_r;
            if (xAxis >= 154 && xAxis <= 166 && yAxis >= this.getScroll() + 18 && yAxis <= this.getScroll() + 18 + 15) {
                if (((TileEntityOredictionificator)this.tileEntity).filters.size() > 3) {
                    this.dragOffset = yAxis - (this.getScroll() + 18);
                    this.isDragging = true;
                } else {
                    this.scroll = 0.0f;
                }
            }
            for (int i = 0; i < 3; ++i) {
                if (((TileEntityOredictionificator)this.tileEntity).filters.get(this.getFilterIndex() + i) == null || !this.overFilter(xAxis, yAxis, i * 22 + 18)) continue;
                SoundHandler.playSound(SoundEvents.field_187909_gi);
                Mekanism.packetHandler.sendToServer(new PacketOredictionificatorGui.OredictionificatorGuiMessage(PacketOredictionificatorGui.OredictionificatorGuiPacket.SERVER_INDEX, Coord4D.get(this.tileEntity), 1, this.getFilterIndex() + i, 0));
            }
        }
    }

    @Override
    protected void func_146273_a(int mouseX, int mouseY, int button, long ticks) {
        super.func_146273_a(mouseX, mouseY, button, ticks);
        if (this.isDragging) {
            int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
            this.scroll = Math.min(Math.max((float)(yAxis - 18 - this.dragOffset) / 73.0f, 0.0f), 1.0f);
        }
    }

    @Override
    protected void func_146286_b(int x, int y, int type) {
        super.func_146286_b(x, y, type);
        if (type == 0 && this.isDragging) {
            this.dragOffset = 0;
            this.isDragging = false;
        }
    }

    @Override
    protected ResourceLocation getGuiLocation() {
        return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiOredictionificator.png");
    }

    public void updateRenderStacks() {
        this.renderStacks.clear();
        for (TileEntityOredictionificator.OredictionificatorFilter filter : ((TileEntityOredictionificator)this.tileEntity).filters) {
            if (filter.filter == null || filter.filter.isEmpty()) {
                this.renderStacks.put(filter, ItemStack.field_190927_a);
                continue;
            }
            NonNullList stacks = OreDictionary.getOres((String)filter.filter, (boolean)false);
            if (stacks.isEmpty()) {
                this.renderStacks.put(filter, ItemStack.field_190927_a);
                continue;
            }
            if (stacks.size() - 1 >= filter.index) {
                this.renderStacks.put(filter, ((ItemStack)stacks.get(filter.index)).func_77946_l());
                continue;
            }
            this.renderStacks.put(filter, ItemStack.field_190927_a);
        }
    }
}

