/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.util.handlers;

import com.barribob.MaelstromMod.particle.EffectParticle;
import com.barribob.MaelstromMod.particle.ModParticle;
import com.barribob.MaelstromMod.util.ModColors;
import com.barribob.MaelstromMod.util.ModRandom;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleBreaking;
import net.minecraft.client.particle.ParticleExplosion;
import net.minecraft.client.particle.ParticleExplosionLarge;
import net.minecraft.client.particle.ParticleFirework;
import net.minecraft.client.particle.ParticleFlame;
import net.minecraft.client.particle.ParticleSmokeNormal;
import net.minecraft.client.particle.ParticleSpell;
import net.minecraft.client.particle.ParticleSuspendedTown;
import net.minecraft.item.Item;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ParticleManager {
    public static void spawnMaelstromParticle(World worldIn, Random rand, Vec3d pos) {
        Particle particle = new ParticleSuspendedTown.Factory().func_178902_a(0, worldIn, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0, 0.0, 0.0, new int[0]);
        ParticleManager.setMaelstromColor(particle);
        Minecraft.func_71410_x().field_71452_i.func_78873_a(particle);
    }

    public static void spawnMaelstromPotionParticle(World worldIn, Random rand, Vec3d pos, boolean isLight) {
        Particle particle = new ParticleSpell.Factory().func_178902_a(0, worldIn, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0, 0.1, 0.0, new int[0]);
        if (isLight) {
            ParticleManager.setMaelstromLightColor(particle);
        } else {
            ParticleManager.setMaelstromColor(particle);
        }
        Minecraft.func_71410_x().field_71452_i.func_78873_a(particle);
    }

    public static void spawnMaelstromExplosion(World worldIn, Random rand, Vec3d pos) {
        Particle particle = new ParticleExplosionLarge.Factory().func_178902_a(0, worldIn, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, (double)ModRandom.getFloat(0.05f), 0.0, (double)ModRandom.getFloat(0.05f), new int[0]);
        ParticleManager.setMaelstromColor(particle);
        Minecraft.func_71410_x().field_71452_i.func_78873_a(particle);
    }

    public static void spawnColoredExplosion(World worldIn, Vec3d pos, Vec3d baseColor) {
        Particle particle = new ParticleExplosionLarge.Factory().func_178902_a(0, worldIn, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, (double)ModRandom.getFloat(0.05f), 0.0, (double)ModRandom.getFloat(0.05f), new int[0]);
        baseColor = ModColors.variateColor(baseColor, 0.2f);
        particle.func_70538_b((float)baseColor.field_72450_a, (float)baseColor.field_72448_b, (float)baseColor.field_72449_c);
        Minecraft.func_71410_x().field_71452_i.func_78873_a(particle);
    }

    public static void spawnMaelstromLargeSmoke(World worldIn, Random rand, Vec3d pos) {
        Particle particle = new ParticleExplosion.Factory().func_178902_a(0, worldIn, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, (double)ModRandom.getFloat(0.05f), 0.0, (double)ModRandom.getFloat(0.05f), new int[0]);
        ParticleManager.setMaelstromColor(particle);
        Minecraft.func_71410_x().field_71452_i.func_78873_a(particle);
    }

    public static void spawnMaelstromSmoke(World worldIn, Random rand, Vec3d pos, boolean isLight) {
        Particle particle = new ParticleSmokeNormal.Factory().func_178902_a(0, worldIn, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0, 0.01, 0.0, new int[0]);
        if (isLight) {
            ParticleManager.setMaelstromLightColor(particle);
        } else {
            ParticleManager.setMaelstromColor(particle);
        }
        Minecraft.func_71410_x().field_71452_i.func_78873_a(particle);
    }

    public static void spawnColoredSmoke(World worldIn, Vec3d pos, Vec3d baseColor, Vec3d vel) {
        Particle particle = new ParticleSmokeNormal.Factory().func_178902_a(0, worldIn, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, vel.field_72450_a, vel.field_72448_b, vel.field_72449_c, new int[0]);
        baseColor = ModColors.variateColor(baseColor, 0.2f);
        particle.func_70538_b((float)baseColor.field_72450_a, (float)baseColor.field_72448_b, (float)baseColor.field_72449_c);
        Minecraft.func_71410_x().field_71452_i.func_78873_a(particle);
    }

    public static void spawnCustomSmoke(World worldIn, Vec3d pos, Vec3d baseColor, Vec3d motion) {
        ModParticle particle = new ModParticle(worldIn, pos, motion, 2.0f, ModRandom.range(20, 30), false);
        particle.setParticleTextureRange(0, 7, 1.0f);
        ParticleManager.spawnParticleWithColor(particle, baseColor);
    }

    public static void spawnSwirl(World worldIn, Vec3d pos, Vec3d baseColor, Vec3d motion, int age) {
        ModParticle particle = new ModParticle(worldIn, pos, motion, 3.0f, age, true);
        particle.setParticleTextureRange(16, 8, 2.0f);
        ParticleManager.spawnParticleWithColor(particle, baseColor);
    }

    public static void spawnSwirl2(World worldIn, Vec3d pos, Vec3d baseColor, Vec3d motion) {
        ModParticle particle = new ModParticle(worldIn, pos, motion, 3.0f, ModRandom.range(10, 20), true);
        particle.setParticleTextureRange(7, 9, 2.0f);
        ParticleManager.spawnParticleWithColor(particle, baseColor);
    }

    public static void spawnWisp(World worldIn, Vec3d pos, Vec3d baseColor, Vec3d motion) {
        ModParticle particle = new ModParticle(worldIn, pos, motion, 3.0f, ModRandom.range(7, 15), false);
        particle.setParticleTextureRange(24, 8, 1.0f);
        ParticleManager.spawnParticleWithColor(particle, baseColor);
    }

    public static void spawnFluff(World worldIn, Vec3d pos, Vec3d baseColor, Vec3d motion) {
        ModParticle particle = new ModParticle(worldIn, pos, motion, 3.0f, ModRandom.range(10, 20), false);
        particle.setParticleTextureRange(32, 10, 1.0f);
        ParticleManager.spawnParticleWithColor(particle, baseColor);
    }

    public static void spawnSplit(World worldIn, Vec3d pos, Vec3d baseColor, Vec3d motion) {
        ModParticle particle = new ModParticle(worldIn, pos, motion, 3.0f, ModRandom.range(7, 20), false);
        particle.setParticleTextureRange(42, 6, 1.0f);
        ParticleManager.spawnParticleWithColor(particle, baseColor);
    }

    public static void spawnCircles(World worldIn, Vec3d pos, Vec3d baseColor, Vec3d motion) {
        ModParticle particle = new ModParticle(worldIn, pos, motion, 3.0f, ModRandom.range(10, 20), true);
        particle.setParticleTextureRange(48, 7, 2.0f);
        ParticleManager.spawnParticleWithColor(particle, baseColor);
    }

    public static void spawnDust(World worldIn, Vec3d pos, Vec3d baseColor, Vec3d motion, int age) {
        ModParticle particle = new ModParticle(worldIn, pos, motion, 3.0f, age, true);
        particle.setParticleTextureRange(64, 14, 2.0f);
        ParticleManager.spawnParticleWithColor(particle, baseColor);
    }

    public static void spawnSmoke2(World worldIn, Vec3d pos, Vec3d baseColor, Vec3d motion) {
        ModParticle particle = new ModParticle(worldIn, pos, motion, 3.0f, ModRandom.range(15, 25), true);
        particle.setParticleTextureRange(80, 23, 2.0f);
        ParticleManager.spawnParticleWithColor(particle, baseColor);
    }

    private static void spawnParticleWithColor(Particle particle, Vec3d baseColor) {
        baseColor = ModColors.variateColor(baseColor, 0.2f);
        particle.func_70538_b((float)baseColor.field_72450_a, (float)baseColor.field_72448_b, (float)baseColor.field_72449_c);
        Minecraft.func_71410_x().field_71452_i.func_78873_a(particle);
    }

    public static void spawnDarkFlames(World worldIn, Random rand, Vec3d pos) {
        ParticleManager.spawnDarkFlames(worldIn, rand, pos, Vec3d.field_186680_a);
    }

    public static void spawnDarkFlames(World worldIn, Random rand, Vec3d pos, Vec3d vel) {
        Particle particle = new ParticleFlame.Factory().func_178902_a(0, worldIn, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, vel.field_72450_a, vel.field_72448_b, vel.field_72449_c, new int[0]);
        float f = ModRandom.getFloat(0.1f);
        particle.func_70538_b(0.1f + f, 0.0f, 0.1f + f);
        Minecraft.func_71410_x().field_71452_i.func_78873_a(particle);
    }

    public static void spawnColoredFire(World worldIn, Random rand, Vec3d pos, Vec3d color) {
        Particle particle = new ParticleFlame.Factory().func_178902_a(0, worldIn, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0, 0.0, 0.0, new int[0]);
        color = ModColors.variateColor(color, 0.2f);
        particle.func_70538_b((float)color.field_72450_a, (float)color.field_72448_b, (float)color.field_72449_c);
        Minecraft.func_71410_x().field_71452_i.func_78873_a(particle);
    }

    public static void spawnEffect(World world, Vec3d pos, Vec3d baseColor) {
        Particle particle = new EffectParticle.Factory().func_178902_a(0, world, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0, 0.0, 0.0, new int[0]);
        baseColor = ModColors.variateColor(baseColor, 0.2f);
        particle.func_70538_b((float)baseColor.field_72450_a, (float)baseColor.field_72448_b, (float)baseColor.field_72449_c);
        Minecraft.func_71410_x().field_71452_i.func_78873_a(particle);
    }

    public static void spawnBreak(World world, Vec3d pos, Item item, Vec3d vel) {
        Particle particle = new ParticleBreaking.Factory().func_178902_a(0, world, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, vel.field_72450_a, vel.field_72448_b, vel.field_72449_c, new int[]{Item.func_150891_b((Item)item)});
        Minecraft.func_71410_x().field_71452_i.func_78873_a(particle);
    }

    public static void spawnFirework(World world, Vec3d pos, Vec3d color) {
        ParticleManager.spawnFirework(world, pos, color, Vec3d.field_186680_a);
    }

    public static void spawnFirework(World world, Vec3d pos, Vec3d color, Vec3d vel) {
        Particle particle = new ParticleFirework.Factory().func_178902_a(0, world, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, vel.field_72450_a, vel.field_72448_b, vel.field_72449_c, new int[0]);
        particle.func_70538_b((float)color.field_72450_a, (float)color.field_72448_b, (float)color.field_72449_c);
        Minecraft.func_71410_x().field_71452_i.func_78873_a(particle);
    }

    public static void spawnParticleSphere(World world, Vec3d pos, float radius) {
        for (int i = 0; i < 1000; ++i) {
            Vec3d unit = new Vec3d(0.0, 1.0, 0.0);
            unit = unit.func_178789_a((float)(Math.PI * (double)ModRandom.getFloat(1.0f)));
            unit = unit.func_178785_b((float)(Math.PI * (double)ModRandom.getFloat(1.0f)));
            unit = unit.func_72432_b().func_186678_a((double)radius);
            ParticleManager.spawnEffect(world, pos.func_178787_e(unit), ModColors.MAELSTROM);
        }
        ParticleManager.spawnEffect(world, pos, ModColors.RED);
    }

    private static void setMaelstromColor(Particle particle) {
        float f = ModRandom.getFloat(0.2f);
        particle.func_70538_b(0.3f + f, 0.2f + f, 0.4f + f);
    }

    private static void setMaelstromLightColor(Particle particle) {
        float f = ModRandom.getFloat(0.2f);
        particle.func_70538_b(0.8f + f, 0.5f + f, 0.8f + f);
    }
}

