/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.items.tools;

import com.barribob.MaelstromMod.Main;
import com.barribob.MaelstromMod.config.ModConfig;
import com.barribob.MaelstromMod.init.ModCreativeTabs;
import com.barribob.MaelstromMod.init.ModItems;
import com.barribob.MaelstromMod.items.ILeveledItem;
import com.barribob.MaelstromMod.items.ISweepAttackOverride;
import com.barribob.MaelstromMod.util.Element;
import com.barribob.MaelstromMod.util.IElement;
import com.barribob.MaelstromMod.util.IHasModel;
import com.barribob.MaelstromMod.util.ModUtils;
import com.barribob.MaelstromMod.util.handlers.LevelHandler;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.world.World;

public class ToolSword
extends ItemSword
implements IHasModel,
ISweepAttackOverride,
ILeveledItem,
IElement {
    private final float level;
    private Consumer<List<String>> information = info -> {};
    private Element element = Element.NONE;

    public ToolSword(String name, Item.ToolMaterial material, float level) {
        super(material);
        this.func_77655_b(name);
        this.setRegistryName(name);
        this.func_77637_a(ModCreativeTabs.ITEMS);
        ModItems.ITEMS.add((Item)this);
        this.level = level;
    }

    public ToolSword(String name, Item.ToolMaterial material, float level, Element element) {
        this(name, material, level);
        this.element = element;
    }

    @Override
    public void registerModels() {
        Main.proxy.registerItemRenderer((Item)this, 0, "inventory");
    }

    @Override
    public float getLevel() {
        return this.level;
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.func_150931_i(), 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", this.getAttackSpeed(), 0));
        }
        return multimap;
    }

    public float func_150931_i() {
        return super.func_150931_i() * LevelHandler.getMultiplierFromLevel(this.level) * ModConfig.balance.weapon_damage;
    }

    protected double getAttackSpeed() {
        return -2.4f;
    }

    public Item setInformation(Consumer<List<String>> information) {
        this.information = information;
        return this;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (!ModConfig.gui.disableMaelstromArmorItemTooltips) {
            tooltip.add(ModUtils.getDisplayLevel(this.level));
        }
        if (!this.element.equals((Object)Element.NONE) && !ModConfig.gui.disableElementalVisuals) {
            tooltip.add(ModUtils.getElementalTooltip(this.element));
        }
        this.information.accept(tooltip);
    }

    @Override
    public void doSweepAttack(EntityPlayer player, EntityLivingBase entity) {
        ModUtils.doSweepAttack(player, entity, this.element, e -> {});
    }

    public static UUID getAttackDamageModifier() {
        return field_111210_e;
    }

    @Override
    public Element getElement() {
        return this.element;
    }

    public ToolSword setElement(Element element) {
        this.element = element;
        return this;
    }
}

