/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.items.armor;

import com.barribob.MaelstromMod.Main;
import com.barribob.MaelstromMod.config.ModConfig;
import com.barribob.MaelstromMod.init.ModCreativeTabs;
import com.barribob.MaelstromMod.init.ModItems;
import com.barribob.MaelstromMod.items.ILeveledItem;
import com.barribob.MaelstromMod.util.Element;
import com.barribob.MaelstromMod.util.IElement;
import com.barribob.MaelstromMod.util.IHasModel;
import com.barribob.MaelstromMod.util.ModUtils;
import com.barribob.MaelstromMod.util.handlers.LevelHandler;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ModArmorBase
extends ItemArmor
implements IHasModel,
ILeveledItem,
IElement {
    private static final UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.fromString("a3578781-e4a8-4d70-9d32-cd952aeae1df"), UUID.fromString("e2d1f056-f539-48c7-b353-30d7a367ebd0"), UUID.fromString("db13047a-bb47-4621-a025-65ed22ce461a"), UUID.fromString("abb5df20-361d-420a-8ec7-4bdba33378eb")};
    private final float level;
    private static final int[] armor_fractions = new int[]{4, 7, 8, 5};
    private static final int armor_total = 24;
    private final String textureName;
    private Element element = Element.NONE;
    private String armorBonusDesc = "";

    public ModArmorBase(String name, ItemArmor.ArmorMaterial materialIn, int renderIndex, EntityEquipmentSlot equipmentSlotIn, float level, String textureName) {
        super(materialIn, renderIndex, equipmentSlotIn);
        this.func_77655_b(name);
        this.setRegistryName(name);
        this.func_77637_a(ModCreativeTabs.ITEMS);
        this.level = level;
        this.textureName = textureName;
        ModItems.ITEMS.add((Item)this);
    }

    public float getElementalArmor(Element element) {
        if (element.matchesElement(this.getElement())) {
            float fullArmorReduction = 1.0f - 1.0f / ModConfig.balance.elemental_factor;
            float armorFraction = (float)armor_fractions[this.field_77881_a.func_188454_b()] / 24.0f;
            return fullArmorReduction * armorFraction;
        }
        return 0.0f;
    }

    public float getMaelstromArmor(ItemStack stack) {
        float total_armor_reduction = 1.0f - LevelHandler.getArmorFromLevel(this.level);
        float armor_type_fraction = (float)armor_fractions[this.field_77881_a.func_188454_b()] / 24.0f;
        return total_armor_reduction * armor_type_fraction;
    }

    public float getMaelstromArmorBars() {
        if (ModConfig.gui.disableMaelstromArmorItemTooltips) {
            return 0.0f;
        }
        float armor_type_fraction = (float)armor_fractions[this.field_77881_a.func_188454_b()] / 24.0f;
        return this.getLevel() * armor_type_fraction;
    }

    @Override
    public void registerModels() {
        Main.proxy.registerItemRenderer((Item)this, 0, "inventory");
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == this.field_77881_a) {
            multimap.put((Object)SharedMonsterAttributes.field_188791_g.func_111108_a(), (Object)new AttributeModifier(ARMOR_MODIFIERS[equipmentSlot.func_188454_b()], "Armor modifier", (double)this.field_77879_b, 0));
            multimap.put((Object)SharedMonsterAttributes.field_189429_h.func_111108_a(), (Object)new AttributeModifier(ARMOR_MODIFIERS[equipmentSlot.func_188454_b()], "Armor toughness", (double)ModConfig.balance.armor_toughness, 0));
            multimap.put((Object)"maelstrom_armor", (Object)new AttributeModifier(ARMOR_MODIFIERS[equipmentSlot.func_188454_b()], "Maelstrom Armor modifier", (double)((float)Math.round(this.getMaelstromArmorBars() * 10.0f) / 10.0f), 0));
        }
        return multimap;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (!ModConfig.gui.disableMaelstromArmorItemTooltips) {
            tooltip.add(ModUtils.getDisplayLevel(this.getLevel()));
        }
        if (!this.element.equals((Object)Element.NONE) && !ModConfig.gui.disableElementalVisuals) {
            tooltip.add(ModUtils.translateDesc("elemental_armor_desc", this.element.textColor + this.element.symbol + TextFormatting.GRAY, ModUtils.ROUND.format(100.0f * this.getElementalArmor(this.element)) + "%"));
        }
        if (!this.armorBonusDesc.isEmpty() && Main.itemsConfig.getBoolean("full_set_bonuses." + this.armorBonusDesc.replace("_full_set", ""))) {
            tooltip.add(ModUtils.translateDesc(this.armorBonusDesc, new Object[0]));
        }
    }

    public ModArmorBase setArmorBonusDesc(String armorBonusDesc) {
        this.armorBonusDesc = armorBonusDesc;
        return this;
    }

    protected ModelBiped getCustomModel() {
        return null;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        if (this.getCustomModel() != null) {
            return "mm:textures/models/armor/" + this.textureName;
        }
        int layer = slot == EntityEquipmentSlot.LEGS ? 2 : 1;
        String t = type == null ? "" : String.format("_%s", type);
        return String.format("%s:textures/models/armor/%s_layer_%d%s.png", "mm", this.textureName, layer, t);
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        if (this.getCustomModel() != null && !itemStack.func_190926_b() && itemStack.func_77973_b() instanceof ModArmorBase) {
            ModelBiped model = this.getCustomModel();
            model.field_78116_c.field_78806_j = armorSlot == EntityEquipmentSlot.HEAD;
            model.field_78115_e.field_78806_j = armorSlot == EntityEquipmentSlot.CHEST;
            model.field_178724_i.field_78806_j = armorSlot == EntityEquipmentSlot.CHEST;
            model.field_178723_h.field_78806_j = armorSlot == EntityEquipmentSlot.CHEST;
            model.field_178722_k.field_78806_j = armorSlot == EntityEquipmentSlot.LEGS || armorSlot == EntityEquipmentSlot.FEET;
            model.field_178721_j.field_78806_j = armorSlot == EntityEquipmentSlot.LEGS || armorSlot == EntityEquipmentSlot.FEET;
            model.field_78091_s = _default.field_78091_s;
            model.field_78093_q = _default.field_78093_q;
            model.field_78117_n = _default.field_78117_n;
            model.field_187076_m = _default.field_187076_m;
            model.field_187075_l = _default.field_187075_l;
            return model;
        }
        return null;
    }

    @Override
    public float getLevel() {
        return this.level;
    }

    @Override
    public Element getElement() {
        return this.element;
    }

    public ModArmorBase setElement(Element element) {
        this.element = element;
        return this;
    }
}

