/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.projectile;

import com.barribob.MaelstromMod.entity.projectile.ProjectileGun;
import com.barribob.MaelstromMod.util.ModColors;
import com.barribob.MaelstromMod.util.ModDamageSource;
import com.barribob.MaelstromMod.util.ModRandom;
import com.barribob.MaelstromMod.util.ModUtils;
import com.barribob.MaelstromMod.util.handlers.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ProjectilePumpkin
extends ProjectileGun {
    private static final int PARTICLE_AMOUNT = 1;
    private static final int IMPACT_PARTICLE_AMOUNT = 50;
    private static final int EXPOSION_AREA_FACTOR = 4;
    private int rings;
    private int maxRings;
    Vec3d prevPos;

    public ProjectilePumpkin(World worldIn, EntityLivingBase throwerIn, float baseDamage, ItemStack stack) {
        super(worldIn, throwerIn, baseDamage, stack);
        this.prevPos = this.func_174791_d();
    }

    public ProjectilePumpkin(World worldIn) {
        super(worldIn);
        this.prevPos = this.func_174791_d();
    }

    public ProjectilePumpkin(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    @Override
    protected void spawnParticles() {
        if (this.field_70173_aa <= 2) {
            this.prevPos = this.func_174791_d();
            return;
        }
        Vec3d vel = this.func_174791_d().func_178788_d(this.prevPos).func_72432_b();
        this.maxRings = ModRandom.range(4, 7);
        float tailWidth = 0.25f;
        ParticleManager.spawnSwirl(this.field_70170_p, new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v).func_178787_e(new Vec3d((double)ModRandom.getFloat(tailWidth), (double)ModRandom.getFloat(tailWidth), (double)ModRandom.getFloat(tailWidth))), ModColors.YELLOW, vel.func_186678_a((double)0.1f), ModRandom.range(25, 30));
        if (this.rings < this.maxRings) {
            float circleSize = 1.0f + ModRandom.getFloat(0.9f);
            float f1 = MathHelper.func_76133_a((double)(vel.field_72450_a * vel.field_72450_a + vel.field_72449_c * vel.field_72449_c));
            ModUtils.circleCallback(circleSize, 30, pos -> {
                Vec3d outer = pos.func_178789_a((float)MathHelper.func_181159_b((double)vel.field_72448_b, (double)f1)).func_178785_b((float)MathHelper.func_181159_b((double)vel.field_72450_a, (double)vel.field_72449_c)).func_178787_e(this.func_174791_d());
                ParticleManager.spawnEffect(this.field_70170_p, outer, ModColors.YELLOW);
            });
            ++this.rings;
        }
        this.prevPos = this.func_174791_d();
    }

    @Override
    protected void onHit(RayTraceResult result) {
        ModUtils.handleBulletImpact(result.field_72308_g, this, (float)((double)this.getGunDamage(result.field_72308_g) * this.getDistanceTraveled()), ModDamageSource.causeElementalThrownDamage(this, (Entity)this.shootingEntity, this.getElement()), this.getKnockback());
        super.onHit(result);
    }
}

