/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.projectile;

import com.barribob.MaelstromMod.entity.projectile.ProjectileAbstractMegaFireball;
import com.barribob.MaelstromMod.entity.projectile.ProjectileFireball;
import com.barribob.MaelstromMod.util.ModColors;
import com.barribob.MaelstromMod.util.ModDamageSource;
import com.barribob.MaelstromMod.util.ModRandom;
import com.barribob.MaelstromMod.util.ModUtils;
import com.barribob.MaelstromMod.util.handlers.ParticleManager;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class ProjectileMegaFireball
extends ProjectileAbstractMegaFireball {
    private static final int PARTICLE_AMOUNT = 15;
    private static final int IMPACT_PARTICLE_AMOUNT = 30;
    private static final int EXPOSION_AREA_FACTOR = 4;

    public ProjectileMegaFireball(World worldIn, EntityLivingBase throwerIn, float baseDamage, ItemStack stack, boolean canTakeDamage) {
        super(worldIn, throwerIn, baseDamage, stack, canTakeDamage);
    }

    public ProjectileMegaFireball(World worldIn) {
        super(worldIn);
    }

    public ProjectileMegaFireball(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    @Override
    protected void spawnParticles() {
        for (int i = 0; i < 15; ++i) {
            Vec3d origin = this.func_174791_d().func_178787_e(ModUtils.getAxisOffset(ModUtils.getEntityVelocity(this).func_72432_b(), new Vec3d(1.0, 0.0, 0.0)));
            Vec3d smokePos = origin.func_178787_e(ModRandom.randVec());
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, smokePos.field_72450_a, smokePos.field_72448_b, smokePos.field_72449_c, 0.0, 0.0, 0.0, new int[0]);
            ParticleManager.spawnEffect(this.field_70170_p, origin.func_178787_e(ModRandom.randVec()), ModColors.FIREBALL_ORANGE);
        }
    }

    @Override
    protected void spawnImpactParticles() {
        for (int i = 0; i < 30; ++i) {
            Vec3d pos = this.func_174791_d().func_178787_e(ModRandom.randVec().func_186678_a(4.0));
            Vec3d vel = pos.func_178788_d(this.func_174791_d()).func_72432_b().func_186678_a((double)(this.field_70170_p.field_73012_v.nextFloat() * 0.3f));
            this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, vel.field_72450_a, vel.field_72448_b, vel.field_72449_c, new int[0]);
        }
    }

    @Override
    protected void onImpact(@Nullable RayTraceResult result) {
        int fireFactor = this.func_70027_ad() ? 10 : 5;
        DamageSource source = ModDamageSource.builder().type("mm:explosionMaelstrom.player").directEntity(this).indirectEntity((Entity)this.shootingEntity).element(this.getElement()).stoppedByArmorNotShields().build();
        ModUtils.handleAreaImpact(7.0f, this::getGunDamage, (Entity)this.shootingEntity, this.func_174791_d(), source, 0.0f, fireFactor);
        boolean flag = ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this.shootingEntity);
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72885_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, 3.0f, true, flag);
            for (int i = 0; i < 10; ++i) {
                Vec3d vel = ModRandom.randVec().func_72432_b().func_186678_a(0.5).func_178787_e(ModUtils.yVec(1.0));
                ProjectileFireball shrapenel = new ProjectileFireball(this.field_70170_p, this.shootingEntity, this.getDamage() * 0.5f, null);
                ModUtils.setEntityPosition(shrapenel, this.func_174791_d().func_178787_e(ModUtils.yVec(1.0)).func_178787_e(ModRandom.randVec()));
                shrapenel.func_189654_d(false);
                shrapenel.setTravelRange(50.0f);
                this.field_70170_p.func_72838_d((Entity)shrapenel);
                ModUtils.setEntityVelocity(shrapenel, vel);
            }
        }
    }

    @Override
    public void func_70071_h_() {
        if (this.field_70173_aa % 3 == 0) {
            this.func_184185_a(SoundEvents.field_187646_bt, 0.2f, ModRandom.getFloat(0.2f) + 1.0f);
        }
        super.func_70071_h_();
    }
}

