/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.entities;

import com.barribob.MaelstromMod.entity.ai.EntityAITimedAttack;
import com.barribob.MaelstromMod.entity.entities.EntityLeveledMob;
import com.barribob.MaelstromMod.entity.entities.EntityMaelstromMob;
import com.barribob.MaelstromMod.entity.projectile.Projectile;
import com.barribob.MaelstromMod.entity.projectile.ProjectileBeastFireball;
import com.barribob.MaelstromMod.entity.projectile.ProjectileBeastQuake;
import com.barribob.MaelstromMod.entity.projectile.ProjectileBone;
import com.barribob.MaelstromMod.entity.projectile.ProjectileBoneQuake;
import com.barribob.MaelstromMod.entity.util.IAttack;
import com.barribob.MaelstromMod.init.ModBBAnimations;
import com.barribob.MaelstromMod.util.ModColors;
import com.barribob.MaelstromMod.util.ModDamageSource;
import com.barribob.MaelstromMod.util.ModRandom;
import com.barribob.MaelstromMod.util.ModUtils;
import com.barribob.MaelstromMod.util.handlers.LootTableHandler;
import com.barribob.MaelstromMod.util.handlers.ParticleManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.World;

public class EntityMaelstromBeast
extends EntityMaelstromMob
implements IAttack {
    private final BossInfoServer bossInfo = new BossInfoServer(this.func_145748_c_(), BossInfo.Color.PURPLE, BossInfo.Overlay.NOTCHED_20);
    private Consumer<EntityLivingBase> attack;
    Runnable spawnQuake = () -> {
        ProjectileBeastQuake projectile = this.isRaged() ? new ProjectileBoneQuake(this.field_70170_p, (EntityLivingBase)this, this.getAttack() * this.getConfigFloat("bone_hammer_wave_damage")) : new ProjectileBeastQuake(this.field_70170_p, (EntityLivingBase)this, this.getAttack() * this.getConfigFloat("hammer_wave_damage"));
        Vec3d projectileOffset = ModUtils.getRelativeOffset((EntityLivingBase)this, new Vec3d(2.0, -2.0, 0.0));
        Vec3d forwardPos = ModUtils.getRelativeOffset((EntityLivingBase)this, new Vec3d(3.0, -2.0, 0.0)).func_178787_e(this.func_174824_e(1.0f));
        ModUtils.throwProjectile((EntityLivingBase)this, forwardPos, (Projectile)projectile, 0.0f, 0.8f, projectileOffset);
    };
    private final Consumer<EntityLivingBase> quake = target -> {
        ModBBAnimations.animation((EntityLivingBase)this, "beast.quake", false);
        ModUtils.leapTowards((EntityLivingBase)this, target.func_174791_d(), 0.0f, 0.5f);
        this.addEvent(this.spawnQuake, 20);
    };
    private final Consumer<EntityLivingBase> swipe = target -> {
        ModBBAnimations.animation((EntityLivingBase)this, "beast.swipe", false);
        this.addEvent(() -> {
            Vec3d offset = this.func_174791_d().func_178787_e(ModUtils.getRelativeOffset((EntityLivingBase)this, new Vec3d(2.0, 0.0, 0.0)));
            Vec3d offset2 = this.func_174791_d().func_178787_e(ModUtils.getRelativeOffset((EntityLivingBase)this, new Vec3d(1.0, 0.0, 1.0)));
            DamageSource source = ModDamageSource.builder().type("mm:mobMaelstrom").directEntity((Entity)this).element(this.getElement()).stoppedByArmorNotShields().disablesShields().build();
            float damage = this.getAttack() * this.getConfigFloat("swipe_damage");
            ModUtils.handleAreaImpact(2.0f, e -> Float.valueOf(damage), (Entity)this, offset, source, 1.0f, 0, false);
            ModUtils.handleAreaImpact(2.0f, e -> Float.valueOf(damage), (Entity)this, offset2, source, 1.0f, 0, false);
            double width = this.getMobConfig().getDouble("swipe_width");
            ModUtils.destroyBlocksInAABB(new AxisAlignedBB(this.func_180425_c()).func_72314_b(width, 1.0, width).func_191194_a(ModUtils.getRelativeOffset((EntityLivingBase)this, new Vec3d(1.0, 1.0, 0.0))), this.field_70170_p, (Entity)this);
            if (this.isRaged()) {
                ModUtils.performNTimes(8, i -> EntityMaelstromBeast.spawnBone(this.field_70170_p, offset.func_178787_e(ModRandom.randVec().func_186678_a(3.0)), this));
            }
            this.func_184185_a(SoundEvents.field_187730_dW, 1.0f, 0.4f + ModRandom.getFloat(0.1f));
        }, 15);
    };
    private final Consumer<EntityLivingBase> roar = target -> {
        ModBBAnimations.animation((EntityLivingBase)this, "beast.roar", false);
        this.addEvent(() -> {
            if (this.isRaged()) {
                ModUtils.spawnMob(this.field_70170_p, this.func_180425_c(), this.getLevel(), this.getMobConfig().getConfig("spawning_algorithm"));
            } else {
                ModUtils.handleAreaImpact(20.0f, e -> {
                    if (e instanceof EntityLivingBase) {
                        ((EntityLivingBase)e).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 120, 3));
                    }
                    return Float.valueOf(0.0f);
                }, (Entity)this, this.func_174791_d(), ModDamageSource.MAELSTROM_DAMAGE);
            }
            this.func_184185_a(SoundEvents.field_187525_aO, 1.0f, 0.9f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        }, 12);
    };
    public final Consumer<EntityLivingBase> spray = target -> {
        ModUtils.leapTowards((EntityLivingBase)this, target.func_174791_d(), 0.0f, 1.6f);
        ModBBAnimations.animation((EntityLivingBase)this, "beast.leap", false);
        this.addEvent(() -> {
            ModBBAnimations.animation((EntityLivingBase)this, "beast.leap", true);
            ModBBAnimations.animation((EntityLivingBase)this, "beast.slam", false);
            Vec3d targetPos = target.func_174824_e(1.0f);
            Vec3d dir = this.func_174824_e(1.0f).func_178788_d(targetPos);
            Vec3d axis = ModUtils.rotateVector2(dir.func_72431_c(ModUtils.Y_AXIS), dir, 90.0).func_72432_b().func_186678_a(5.0);
            ModUtils.lineCallback(targetPos.func_178787_e(axis), targetPos.func_178788_d(axis), 5, (pos, i) -> {
                ProjectileBeastFireball projectile = new ProjectileBeastFireball(this.field_70170_p, (EntityLivingBase)this, this.getAttack() * this.getConfigFloat("high_leap_fireball_damage"));
                ModUtils.throwProjectile((EntityLivingBase)this, pos, (Projectile)projectile, 4.0f, 0.7f);
            });
        }, 30);
    };
    private final Consumer<EntityLivingBase> leap = target -> {
        ModBBAnimations.animation((EntityLivingBase)this, "beast.leap", false);
        this.addEvent(() -> {
            ModUtils.leapTowards((EntityLivingBase)this, target.func_174791_d(), 1.8f, 0.75f);
            this.setLeaping(true);
        }, 16);
    };

    public EntityMaelstromBeast(World worldIn) {
        super(worldIn);
        this.healthScaledAttackFactor = 0.2;
        this.func_70105_a(1.4f, 2.5f);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(4, new EntityAITimedAttack<EntityMaelstromBeast>(this, 1.25, 50, 30.0f, 0.5f, 10.0f));
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.isRaged()) {
            this.field_70170_p.func_72960_a((Entity)this, ModUtils.SECOND_PARTICLE_BYTE);
        }
        if (!this.field_70170_p.field_72995_K && this.isLeaping() && this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) < Math.pow(4.0, 2.0)) {
            this.setLeaping(false);
            this.onStopLeaping();
        }
        if (!this.field_70170_p.field_72995_K && this.isLeaping()) {
            AxisAlignedBB box = this.func_174813_aQ().func_72314_b(0.25, 0.12, 0.25).func_72317_d(0.0, 0.12, 0.0);
            ModUtils.destroyBlocksInAABB(box, this.field_70170_p, (Entity)this);
        }
    }

    @Override
    public void func_70103_a(byte id) {
        if (id == ModUtils.SECOND_PARTICLE_BYTE) {
            ParticleManager.spawnEffect(this.field_70170_p, this.func_174791_d().func_178787_e(ModRandom.randVec().func_186678_a(2.0)).func_178787_e(ModUtils.yVec(this.func_70047_e())), ModColors.RED);
        }
        super.func_70103_a(id);
    }

    public boolean isRaged() {
        return (double)this.func_110143_aJ() <= this.getMobConfig().getDouble("second_phase_hp");
    }

    @Override
    public int startAttack(EntityLivingBase target, float distanceSq, boolean strafingBackwards) {
        if (target.field_70163_u - this.field_70163_u > 3.0) {
            this.spray.accept(target);
            return 50;
        }
        if ((double)distanceSq > Math.pow(12.0, 2.0)) {
            this.leap.accept(target);
            return 50;
        }
        ArrayList<Consumer> attacks = new ArrayList<Consumer>(Arrays.asList(this.swipe, this.roar, this.quake));
        double[] weights = new double[]{Math.sqrt(Math.max(0.0, Math.pow(5.0, 2.0) - (double)distanceSq)), this.attack != this.roar ? 0.5 : 0.0, 1.0};
        this.attack = ModRandom.choice(attacks, this.field_70146_Z, weights).next();
        this.attack.accept(target);
        return 50;
    }

    @Override
    public void onStopLeaping() {
        ModBBAnimations.animation((EntityLivingBase)this, "beast.leap", true);
        if (this.func_70638_az() != null && this.func_70638_az().func_70068_e((Entity)this) < Math.pow(12.0, 2.0)) {
            ModBBAnimations.animation((EntityLivingBase)this, "beast.slam", false);
            this.addEvent(this.spawnQuake, 4);
        } else {
            ModBBAnimations.animation((EntityLivingBase)this, "beast.reset", false);
        }
    }

    public static void spawnBone(World world, Vec3d pos, EntityLeveledMob entity) {
        if (!world.field_72995_K) {
            ProjectileBone projectile = new ProjectileBone(world, (EntityLivingBase)entity, entity.getAttack() * entity.getConfigFloat("bone_projectile_damage"));
            projectile.func_70107_b(pos.field_72450_a, pos.field_72448_b + 1.5, pos.field_72449_c);
            double xDir = ModRandom.getFloat(0.1f);
            double yDir = 1.0f + ModRandom.getFloat(0.1f);
            double zDir = ModRandom.getFloat(0.1f);
            projectile.func_70186_c(xDir, yDir, zDir, 0.5f, 0.5f);
            world.func_72838_d((Entity)projectile);
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
        super.func_70037_a(compound);
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    protected void func_70619_bc() {
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        super.func_70619_bc();
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_190026_er;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_190029_eu;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_190028_et;
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return LootTableHandler.BEAST;
    }

    protected float func_70647_i() {
        return super.func_70647_i() * 0.8f;
    }

    protected float func_70599_aP() {
        return 0.6f;
    }

    @Override
    protected boolean func_70692_ba() {
        return false;
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
    }
}

