/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.entities;

import com.barribob.MaelstromMod.Main;
import com.barribob.MaelstromMod.config.ModConfig;
import com.barribob.MaelstromMod.entity.ai.ModFlyingNavigator;
import com.barribob.MaelstromMod.entity.ai.ModGroundNavigator;
import com.barribob.MaelstromMod.entity.animation.Animation;
import com.barribob.MaelstromMod.entity.animation.AnimationNone;
import com.barribob.MaelstromMod.entity.util.LeapingEntity;
import com.barribob.MaelstromMod.util.Element;
import com.barribob.MaelstromMod.util.IAnimatedMob;
import com.barribob.MaelstromMod.util.IElement;
import com.barribob.MaelstromMod.util.ModRandom;
import com.barribob.MaelstromMod.util.ModUtils;
import com.barribob.MaelstromMod.util.handlers.SoundsHandler;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.PriorityQueue;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityLeveledMob
extends EntityCreature
implements IAnimatedMob,
IElement,
LeapingEntity {
    protected static final DataParameter<Float> LEVEL = EntityDataManager.func_187226_a(EntityLeveledMob.class, (DataSerializer)DataSerializers.field_187193_c);
    private float regenStartTimer;
    private static final float regenStartTime = 60.0f;
    protected static final DataParameter<Integer> ELEMENT = EntityDataManager.func_187226_a(EntityLeveledMob.class, (DataSerializer)DataSerializers.field_187192_b);
    @SideOnly(value=Side.CLIENT)
    protected Animation currentAnimation;
    protected static final DataParameter<Boolean> IMMOVABLE = EntityDataManager.func_187226_a(EntityLeveledMob.class, (DataSerializer)DataSerializers.field_187198_h);
    private Vec3d initialPosition = null;
    protected double healthScaledAttackFactor = 0.0;
    private final PriorityQueue<TimedEvent> events = new PriorityQueue();
    private boolean leaping = false;

    public EntityLeveledMob(World worldIn) {
        super(worldIn);
        this.setLevel(0.0f);
        this.field_70728_aV = 5;
        if (this.getMobConfig().hasPath("nbt_spawn_data")) {
            this.func_70020_e(ModUtils.parseNBTFromConfig(this.getMobConfig().getConfig("nbt_spawn_data")));
        }
    }

    public Config getMobConfig() {
        String entityName;
        EntityEntry entry = EntityRegistry.getEntry(this.getClass());
        if (entry != null && Main.mobsConfig.hasPath(entityName = entry.getName())) {
            return Main.mobsConfig.getConfig(entityName);
        }
        return ConfigFactory.empty();
    }

    public float getConfigFloat(String path) {
        return (float)this.getMobConfig().getDouble(path);
    }

    protected PathNavigate func_175447_b(World worldIn) {
        if (ModConfig.entities.useVanillaPathfinding) {
            return super.func_175447_b(worldIn);
        }
        if (this.func_70005_c_().toLowerCase().contains("statue") || this.func_70005_c_().toLowerCase().contains("gauntlet")) {
            return new ModFlyingNavigator((EntityLiving)this, worldIn);
        }
        return new ModGroundNavigator((EntityLiving)this, worldIn);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 13 && this.currentAnimation == null) {
            this.initAnimation();
        } else {
            super.func_70103_a(id);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void initAnimation() {
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        if (!this.isImmovable()) {
            super.func_70091_d(type, x, y, z);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70128_L && this.func_110143_aJ() > 0.0f) {
            boolean foundEvent = true;
            while (foundEvent) {
                TimedEvent event = this.events.peek();
                if (event != null && event.ticks <= this.field_70173_aa) {
                    this.events.remove();
                    event.callback.run();
                    continue;
                }
                foundEvent = false;
            }
        }
        if (this.field_70170_p.field_72995_K && this.currentAnimation != null && this.func_110143_aJ() > 0.0f) {
            this.currentAnimation.update();
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70638_az() == null) {
                if (this.regenStartTimer > 60.0f) {
                    if (this.field_70173_aa % 20 == 0) {
                        // empty if block
                    }
                } else {
                    this.regenStartTimer += 1.0f;
                }
            } else {
                this.regenStartTimer = 0.0f;
            }
        }
        if (this.field_70173_aa % 20 == 1) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)13);
        }
        if (this.isImmovable() && this.initialPosition != null) {
            this.func_70107_b(this.initialPosition.field_72450_a, this.initialPosition.field_72448_b, this.initialPosition.field_72449_c);
        }
    }

    protected boolean isImmovable() {
        return this.field_70180_af != null && (Boolean)this.field_70180_af.func_187225_a(IMMOVABLE) != false;
    }

    protected void setImmovable(boolean immovable) {
        this.field_70180_af.func_187227_b(IMMOVABLE, (Object)immovable);
    }

    public void setImmovablePosition(Vec3d pos) {
        this.initialPosition = pos;
        this.func_70107_b(0.0, 0.0, 0.0);
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
        if (this.isImmovable()) {
            if (this.initialPosition == null) {
                this.initialPosition = ModUtils.entityPos((Entity)this);
            } else {
                super.func_70107_b(this.initialPosition.field_72450_a, this.initialPosition.field_72448_b, this.initialPosition.field_72449_c);
            }
        }
    }

    @Override
    public Animation getCurrentAnimation() {
        return this.currentAnimation == null ? new AnimationNone() : this.currentAnimation;
    }

    public float getLevel() {
        return this.field_70180_af == null ? 0.0f : ((Float)this.field_70180_af.func_187225_a(LEVEL)).floatValue();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_193334_e);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111128_a(0.0);
    }

    public EntityLeveledMob setLevel(float level) {
        this.field_70180_af.func_187227_b(LEVEL, (Object)Float.valueOf(level));
        return this;
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74776_a("level", this.getLevel());
        compound.func_74757_a("isImmovable", this.isImmovable());
        compound.func_74768_a("element", this.getElement().id);
        compound.func_74768_a("experienceValue", this.field_70728_aV);
        if (this.initialPosition != null) {
            compound.func_74780_a("initialX", this.initialPosition.field_72450_a);
            compound.func_74780_a("initialY", this.initialPosition.field_72448_b);
            compound.func_74780_a("initialZ", this.initialPosition.field_72449_c);
        }
        super.func_70014_b(compound);
    }

    public void func_70020_e(NBTTagCompound compound) {
        if (compound.func_74764_b("level")) {
            this.setLevel(compound.func_74760_g("level"));
        }
        if (compound.func_74764_b("element")) {
            this.setElement(Element.getElementFromId(compound.func_74762_e("element")));
        }
        this.field_70170_p.func_72960_a((Entity)this, (byte)13);
        super.func_70020_e(compound);
        if (compound.func_74764_b("experienceValue")) {
            this.field_70728_aV = compound.func_74762_e("experienceValue");
        }
        if (compound.func_74764_b("isImmovable")) {
            this.setImmovable(compound.func_74767_n("isImmovable"));
        }
        this.initialPosition = null;
        if (compound.func_74764_b("initialX")) {
            this.initialPosition = new Vec3d(compound.func_74769_h("initialX"), compound.func_74769_h("initialY"), compound.func_74769_h("initialZ"));
        }
    }

    public float getAttack() {
        return ModUtils.getMobDamage(this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e(), this.healthScaledAttackFactor, this.func_110138_aP(), this.func_110143_aJ(), this.getLevel(), this.getElement());
    }

    protected float func_70655_b(DamageSource source, float damage) {
        return super.func_70655_b(source, ModUtils.getArmoredDamage(source, damage, this.getLevel(), this.getElement()));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(LEVEL, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(IMMOVABLE, (Object)false);
        this.field_70180_af.func_187214_a(ELEMENT, (Object)Element.NONE.id);
    }

    @Override
    public Element getElement() {
        return this.field_70180_af == null ? Element.getElementFromId(Element.NONE.id) : Element.getElementFromId((Integer)this.field_70180_af.func_187225_a(ELEMENT));
    }

    public EntityLeveledMob setElement(Element element) {
        this.field_70180_af.func_187227_b(ELEMENT, (Object)element.id);
        return this;
    }

    public void doRender(RenderManager renderManager, double x, double y, double z, float entityYaw, float partialTicks) {
    }

    public void addEvent(Runnable runnable, int ticksFromNow) {
        this.events.add(new TimedEvent(runnable, this.field_70173_aa + ticksFromNow));
    }

    @Override
    public boolean isLeaping() {
        return this.leaping;
    }

    @Override
    public void setLeaping(boolean leaping) {
        this.leaping = leaping;
    }

    protected Vec3d getInitialPosition() {
        return this.initialPosition;
    }

    @Override
    public void onStopLeaping() {
    }

    public void playSoundWithFallback(SoundEvent sound, SoundEvent fallback, float volume, float pitch) {
        this.func_184185_a(ModUtils.getConfiguredSound(sound, fallback), volume, pitch);
    }

    public void playSoundWithFallback(SoundEvent sound, SoundEvent fallback, float volume) {
        this.func_184185_a(ModUtils.getConfiguredSound(sound, fallback), volume, 1.0f + ModRandom.getFloat(0.2f));
    }

    public void playSoundWithFallback(SoundEvent sound, SoundEvent fallback) {
        this.playSoundWithFallback(sound, fallback, 1.0f);
    }

    public void playSoundWithFallback(SoundEvent sound) {
        this.playSoundWithFallback(sound, SoundsHandler.NONE);
    }

    public boolean func_184207_aI() {
        return super.func_184207_aI() || this.getMobConfig().hasPath("can_be_pushed") && !this.getMobConfig().getBoolean("can_be_pushed");
    }

    private static class TimedEvent
    implements Comparable<TimedEvent> {
        Runnable callback;
        int ticks;

        public TimedEvent(Runnable callback, int ticks) {
            this.callback = callback;
            this.ticks = ticks;
        }

        @Override
        public int compareTo(TimedEvent event) {
            return event.ticks < this.ticks ? 1 : -1;
        }
    }
}

