/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.animation;

import com.barribob.MaelstromMod.init.ModBBAnimations;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;

public class BBAnimation {
    private final JsonObject animation;
    private long ticksSinceStart = 0L;
    private final String animationId;
    private final float animationLength;
    private boolean loop = false;

    public boolean isLoop() {
        return this.loop;
    }

    public BBAnimation(String animationId) {
        this.animationId = animationId;
        this.animation = ModBBAnimations.getAnimation(animationId);
        this.animationLength = this.animation.get("animation_length").getAsFloat();
        if (this.animation.has("loop")) {
            this.loop = this.animation.get("loop").getAsBoolean();
        }
    }

    public void setModelRotations(ModelBase model, float limbSwing, float limbSwingAmount, float partialTicks) {
        float timeInSeconds;
        if (this.loop) {
            timeInSeconds = ((float)this.ticksSinceStart + partialTicks) * 0.05f;
            float numRepetitions = (float)Math.floor(timeInSeconds / this.animationLength);
            timeInSeconds -= this.animationLength * numRepetitions;
        } else {
            timeInSeconds = ((float)this.ticksSinceStart + partialTicks) * 0.05f;
        }
        for (Map.Entry elementEntry : this.animation.getAsJsonObject("bones").entrySet()) {
            JsonObject element = ((JsonElement)elementEntry.getValue()).getAsJsonObject();
            try {
                Field field = model.getClass().getDeclaredField((String)elementEntry.getKey());
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                ModelRenderer component = (ModelRenderer)field.get(model);
            }
            catch (IllegalAccessException | NoSuchFieldException | SecurityException e) {
                System.err.println("Animation failure: Failed to access field " + (String)elementEntry.getKey() + " for animationid " + this.animationId + " " + e);
                break;
            }
            if (element.has("rotation")) {
                float[] rotations = BBAnimation.getInterpotatedValues(timeInSeconds, element.getAsJsonObject("rotation").entrySet());
                component.field_78795_f += (float)Math.toRadians(rotations[0]);
                component.field_78796_g += (float)Math.toRadians(rotations[1]);
                component.field_78808_h += (float)Math.toRadians(rotations[2]);
            }
            if (!element.has("position")) continue;
            float[] offsets = BBAnimation.getInterpotatedValues(timeInSeconds, element.getAsJsonObject("position").entrySet());
            component.field_78800_c += offsets[0];
            component.field_78797_d -= offsets[1];
            component.field_78798_e += offsets[2];
        }
    }

    private static float[] getInterpotatedValues(float timeInSeconds, Set<Map.Entry<String, JsonElement>> set) {
        ArrayList entries = Lists.newArrayList(set);
        entries.sort((entry1, entry2) -> {
            float timeStamp2;
            float timeStamp1 = Float.parseFloat((String)entry1.getKey());
            return timeStamp1 > (timeStamp2 = Float.parseFloat((String)entry2.getKey())) ? 1 : -1;
        });
        List<Map.Entry<String, JsonElement>> values = BBAnimation.findElementsBetweenTime(timeInSeconds, entries);
        float clipBegin = Float.parseFloat(values.get(0).getKey());
        float clipEnd = Float.parseFloat(values.get(1).getKey());
        float clipLength = clipEnd - clipBegin;
        float progress = clipLength == 0.0f ? 1.0f : (timeInSeconds - clipBegin) / clipLength;
        JsonArray beginValues = values.get(0).getValue().getAsJsonArray();
        JsonArray endValues = values.get(1).getValue().getAsJsonArray();
        float[] finalValues = new float[3];
        for (int i = 0; i < 3; ++i) {
            float begin = beginValues.get(i).getAsFloat();
            float end = endValues.get(i).getAsFloat();
            finalValues[i] = begin + (end - begin) * progress;
        }
        return finalValues;
    }

    private static List<Map.Entry<String, JsonElement>> findElementsBetweenTime(float timeInSeconds, List<Map.Entry<String, JsonElement>> allEntries) {
        Map.Entry<String, JsonElement> previousEntry = null;
        ArrayList<Map.Entry<String, JsonElement>> entries = new ArrayList<Map.Entry<String, JsonElement>>();
        for (Map.Entry<String, JsonElement> rotationEntry : allEntries) {
            float timeStamp = Float.parseFloat(rotationEntry.getKey());
            if (timeStamp > timeInSeconds) {
                if (previousEntry != null) {
                    entries.add(previousEntry);
                    entries.add(rotationEntry);
                } else {
                    entries.add(rotationEntry);
                    entries.add(rotationEntry);
                }
                return entries;
            }
            previousEntry = rotationEntry;
        }
        entries.add(previousEntry);
        entries.add(previousEntry);
        return entries;
    }

    public void update() {
        ++this.ticksSinceStart;
    }

    public void startAnimation() {
        this.ticksSinceStart = 0L;
    }

    public long getTicksSinceStart() {
        return this.ticksSinceStart;
    }

    public boolean isEnded() {
        return !this.loop && (float)this.ticksSinceStart * 0.05f > this.animationLength;
    }

    public boolean isAtAnimationEnd(float partialTicks) {
        return (double)(((float)this.ticksSinceStart + partialTicks) * 0.05f % this.animationLength) < 0.1;
    }
}

