/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.dimensions.world.lost.cityassets;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import mcjty.lostcities.dimensions.world.lost.cityassets.Palette;
import mcjty.lostcities.dimensions.world.terraingen.LostCitiesTerrainGenerator;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import org.apache.commons.lang3.tuple.Pair;

public class CompiledPalette {
    private final Map<Character, Object> palette = new HashMap<Character, Object>();
    private final Map<Character, Character> damagedToBlock = new HashMap<Character, Character>();
    private final Map<Character, Info> information = new HashMap<Character, Info>();

    public CompiledPalette(CompiledPalette other, Palette ... palettes) {
        this.palette.putAll(other.palette);
        this.damagedToBlock.putAll(other.damagedToBlock);
        this.information.putAll(other.information);
        this.addPalettes(palettes);
    }

    public CompiledPalette(Palette ... palettes) {
        this.addPalettes(palettes);
    }

    private int addEntries(char[] randomBlocks, int idx, char c, int cnt) {
        for (int i = 0; i < cnt; ++i) {
            if (idx >= randomBlocks.length) {
                return idx;
            }
            randomBlocks[idx++] = c;
        }
        return idx;
    }

    public void addPalettes(Palette[] palettes) {
        for (Palette p : palettes) {
            for (Map.Entry<Character, Object> entry : p.palette.entrySet()) {
                Object object = entry.getValue();
                if (object instanceof IBlockState) {
                    this.palette.put(entry.getKey(), Character.valueOf((char)Block.field_176229_d.func_148747_b((Object)((IBlockState)object))));
                    continue;
                }
                if (object instanceof Pair[]) {
                    Pair pair;
                    Pair[] r = (Pair[])object;
                    char[] randomBlocks = new char[128];
                    int idx = 0;
                    Pair[] pairArray = r;
                    int n = pairArray.length;
                    for (int i = 0; i < n && (idx = this.addEntries(randomBlocks, idx, (char)Block.field_176229_d.func_148747_b((pair = pairArray[i]).getRight()), (Integer)pair.getLeft())) < randomBlocks.length; ++i) {
                    }
                    this.palette.put(entry.getKey(), randomBlocks);
                    continue;
                }
                if (object instanceof String) continue;
                if (object == null) {
                    throw new RuntimeException("Invalid palette entry for '" + entry.getKey() + "'!");
                }
                this.palette.put(entry.getKey(), object);
            }
        }
        boolean dirty = true;
        while (dirty) {
            dirty = false;
            for (Palette p : palettes) {
                for (Map.Entry<Object, Object> entry : p.palette.entrySet()) {
                    char c;
                    Object value = entry.getValue();
                    if (!(value instanceof String) || !this.palette.containsKey(Character.valueOf(c = ((String)value).charAt(0))) || this.palette.containsKey(entry.getKey())) continue;
                    Object s = this.palette.get(Character.valueOf(c));
                    if (s instanceof IBlockState) {
                        s = Character.valueOf((char)Block.field_176229_d.func_148747_b((Object)((IBlockState)value)));
                    }
                    this.palette.put((Character)entry.getKey(), s);
                    dirty = true;
                }
            }
        }
        for (Palette p : palettes) {
            Object c;
            for (Map.Entry<Object, Object> entry : p.getDamaged().entrySet()) {
                c = (IBlockState)entry.getKey();
                this.damagedToBlock.put(Character.valueOf((char)Block.field_176229_d.func_148747_b(c)), Character.valueOf((char)Block.field_176229_d.func_148747_b(entry.getValue())));
            }
            for (Map.Entry<Object, Object> entry : p.getMobIds().entrySet()) {
                c = (Character)entry.getKey();
                this.information.put((Character)c, new Info((String)entry.getValue(), null, null));
            }
            for (Map.Entry<Object, Object> entry : p.getLootTables().entrySet()) {
                c = (Character)entry.getKey();
                this.information.put((Character)c, new Info(null, (String)entry.getValue(), null));
            }
            for (Map.Entry<Object, Object> entry : p.getTorchOrientations().entrySet()) {
                c = (Character)entry.getKey();
                this.information.put((Character)c, new Info(null, null, (Map)entry.getValue()));
            }
        }
    }

    public Set<Character> getCharacters() {
        return this.palette.keySet();
    }

    public IBlockState getStraight(char c) {
        try {
            Object o = this.palette.get(Character.valueOf(c));
            if (o instanceof IBlockState) {
                return (IBlockState)o;
            }
            if (o instanceof Character) {
                return (IBlockState)Block.field_176229_d.func_148745_a((int)((Character)o).charValue());
            }
            char[] randomBlocks = (char[])o;
            return (IBlockState)Block.field_176229_d.func_148745_a((int)randomBlocks[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isSimple(char c) {
        Object o = this.palette.get(Character.valueOf(c));
        return o instanceof Character;
    }

    public Character get(char c, Random rand) {
        try {
            Object o = this.palette.get(Character.valueOf(c));
            if (o instanceof Character) {
                return (Character)o;
            }
            if (o == null) {
                return null;
            }
            char[] randomBlocks = (char[])o;
            return Character.valueOf(randomBlocks[rand.nextInt(128)]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Character get(char c) {
        try {
            Object o = this.palette.get(Character.valueOf(c));
            if (o instanceof Character) {
                return (Character)o;
            }
            if (o == null) {
                return null;
            }
            char[] randomBlocks = (char[])o;
            return Character.valueOf(randomBlocks[LostCitiesTerrainGenerator.fastrand128()]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Character canBeDamagedToIronBars(Character b) {
        return this.damagedToBlock.get(b);
    }

    public Info getInfo(Character c) {
        return this.information.get(c);
    }

    public static class Info {
        private final String mobId;
        private final String loot;
        private final Map<String, Integer> torchOrientations;

        public Info(String mobId, String loot, Map<String, Integer> torchOrientations) {
            this.mobId = mobId;
            this.loot = loot;
            this.torchOrientations = torchOrientations;
        }

        public String getMobId() {
            return this.mobId;
        }

        public String getLoot() {
            return this.loot;
        }

        public Map<String, Integer> getTorchOrientations() {
            return this.torchOrientations;
        }
    }
}

