/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.dimensions.world.lost;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import mcjty.lostcities.config.LostCityProfile;
import mcjty.lostcities.dimensions.world.LostCityChunkGenerator;
import mcjty.lostcities.dimensions.world.lost.BiomeInfo;
import mcjty.lostcities.dimensions.world.lost.BuildingInfo;
import mcjty.lostcities.dimensions.world.lost.CitySphere;
import mcjty.lostcities.dimensions.world.lost.cityassets.AssetRegistries;
import mcjty.lostcities.dimensions.world.lost.cityassets.CityStyle;
import mcjty.lostcities.dimensions.world.lost.cityassets.PredefinedCity;
import mcjty.lostcities.varia.ChunkCoord;
import mcjty.lostcities.varia.Tools;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import org.apache.commons.lang3.tuple.Pair;

public class City {
    private static Map<ChunkCoord, PredefinedCity> predefinedCityMap = null;
    private static Map<ChunkCoord, PredefinedCity.PredefinedBuilding> predefinedBuildingMap = null;
    private static Map<ChunkCoord, PredefinedCity.PredefinedStreet> predefinedStreetMap = null;

    public static void cleanCache() {
        predefinedCityMap = null;
        predefinedBuildingMap = null;
        predefinedStreetMap = null;
    }

    public static PredefinedCity getPredefinedCity(int chunkX, int chunkZ, LostCityChunkGenerator provider) {
        if (predefinedCityMap == null) {
            predefinedCityMap = new HashMap<ChunkCoord, PredefinedCity>();
            for (PredefinedCity city : AssetRegistries.PREDEFINED_CITIES.getIterable()) {
                predefinedCityMap.put(new ChunkCoord(city.getDimension(), city.getChunkX(), city.getChunkZ()), city);
            }
        }
        if (predefinedCityMap.isEmpty()) {
            return null;
        }
        return predefinedCityMap.get(new ChunkCoord(provider.dimensionId, chunkX, chunkZ));
    }

    public static PredefinedCity.PredefinedBuilding getPredefinedBuilding(int chunkX, int chunkZ, LostCityChunkGenerator provider) {
        if (predefinedBuildingMap == null) {
            predefinedBuildingMap = new HashMap<ChunkCoord, PredefinedCity.PredefinedBuilding>();
            for (PredefinedCity city : AssetRegistries.PREDEFINED_CITIES.getIterable()) {
                for (PredefinedCity.PredefinedBuilding building : city.getPredefinedBuildings()) {
                    predefinedBuildingMap.put(new ChunkCoord(city.getDimension(), city.getChunkX() + building.getRelChunkX(), city.getChunkZ() + building.getRelChunkZ()), building);
                }
            }
        }
        if (predefinedBuildingMap.isEmpty()) {
            return null;
        }
        return predefinedBuildingMap.get(new ChunkCoord(provider.dimensionId, chunkX, chunkZ));
    }

    public static PredefinedCity.PredefinedStreet getPredefinedStreet(int chunkX, int chunkZ, LostCityChunkGenerator provider) {
        if (predefinedStreetMap == null) {
            predefinedStreetMap = new HashMap<ChunkCoord, PredefinedCity.PredefinedStreet>();
            for (PredefinedCity city : AssetRegistries.PREDEFINED_CITIES.getIterable()) {
                for (PredefinedCity.PredefinedStreet street : city.getPredefinedStreets()) {
                    predefinedStreetMap.put(new ChunkCoord(city.getDimension(), city.getChunkX() + street.getRelChunkX(), city.getChunkZ() + street.getRelChunkZ()), street);
                }
            }
        }
        if (predefinedStreetMap.isEmpty()) {
            return null;
        }
        return predefinedStreetMap.get(new ChunkCoord(provider.dimensionId, chunkX, chunkZ));
    }

    public static boolean isCityCenter(int chunkX, int chunkZ, LostCityChunkGenerator provider) {
        PredefinedCity city = City.getPredefinedCity(chunkX, chunkZ, provider);
        if (city != null) {
            return true;
        }
        Random rand = new Random(provider.seed + (long)chunkZ * 797003437L + (long)chunkX * 295075153L);
        rand.nextFloat();
        rand.nextFloat();
        if (provider.getProfile().isSpace()) {
            CitySphere sphere = CitySphere.getCitySphere(chunkX, chunkZ, provider);
            if (!sphere.isEnabled()) {
                return rand.nextFloat() < provider.getOutsideProfile().CITY_CHANCE;
            }
            if (sphere.getCenter().getChunkX() == chunkX && sphere.getCenter().getChunkZ() == chunkZ) {
                return rand.nextFloat() < provider.getProfile().CITY_CHANCE;
            }
            return false;
        }
        return rand.nextFloat() < provider.getProfile().CITY_CHANCE;
    }

    public static float getCityRadius(int chunkX, int chunkZ, LostCityChunkGenerator provider) {
        PredefinedCity city = City.getPredefinedCity(chunkX, chunkZ, provider);
        if (city != null) {
            return city.getRadius();
        }
        Random rand = new Random(provider.seed + (long)chunkZ * 100001653L + (long)chunkX * 295075153L);
        rand.nextFloat();
        rand.nextFloat();
        LostCityProfile profile = provider.getProfile();
        if (profile.isSpace() && profile.CITYSPHERE_LANDSCAPE_OUTSIDE) {
            if (CitySphere.intersectsWithCitySphere(chunkX, chunkZ, provider)) {
                return profile.CITY_MINRADIUS + rand.nextInt(profile.CITY_MAXRADIUS - profile.CITY_MINRADIUS);
            }
            return provider.getOutsideProfile().CITY_MINRADIUS + rand.nextInt(provider.getOutsideProfile().CITY_MAXRADIUS - provider.getOutsideProfile().CITY_MINRADIUS);
        }
        return profile.CITY_MINRADIUS + rand.nextInt(profile.CITY_MAXRADIUS - profile.CITY_MINRADIUS);
    }

    public static String getCityStyleForCityCenter(int chunkX, int chunkZ, LostCityChunkGenerator provider) {
        PredefinedCity city = City.getPredefinedCity(chunkX, chunkZ, provider);
        if (city != null && city.getCityStyle() != null) {
            return city.getCityStyle();
        }
        Random rand = new Random(provider.seed + (long)chunkZ * 899809363L + (long)chunkX * 256203221L);
        rand.nextFloat();
        rand.nextFloat();
        return provider.worldStyle.getRandomCityStyle(provider, chunkX, chunkZ, rand);
    }

    public static CityStyle getCityStyle(int chunkX, int chunkZ, LostCityChunkGenerator provider, LostCityProfile profile) {
        Random rand = new Random(provider.seed + (long)chunkZ * 593441843L + (long)chunkX * 217645177L);
        rand.nextFloat();
        rand.nextFloat();
        int offset = (profile.CITY_MAXRADIUS + 15) / 16;
        ArrayList<Pair<Float, String>> styles = new ArrayList<Pair<Float, String>>();
        for (int cx = chunkX - offset; cx <= chunkX + offset; ++cx) {
            for (int cz = chunkZ - offset; cz <= chunkZ + offset; ++cz) {
                float radius;
                float sqdist;
                if (!City.isCityCenter(cx, cz, provider) || !((sqdist = (float)((cx * 16 - chunkX * 16) * (cx * 16 - chunkX * 16) + (cz * 16 - chunkZ * 16) * (cz * 16 - chunkZ * 16))) < (radius = City.getCityRadius(cx, cz, provider)) * radius)) continue;
                float dist = (float)Math.sqrt(sqdist);
                float factor = (radius - dist) / radius;
                styles.add((Pair<Float, String>)Pair.of((Object)Float.valueOf(factor), (Object)City.getCityStyleForCityCenter(chunkX, chunkZ, provider)));
            }
        }
        String cityStyleName = styles.isEmpty() ? provider.worldStyle.getRandomCityStyle(provider, chunkX, chunkZ, rand) : Tools.getRandomFromList(rand, styles);
        return AssetRegistries.CITYSTYLES.get(cityStyleName);
    }

    public static float getCityFactor(int chunkX, int chunkZ, LostCityChunkGenerator provider, LostCityProfile profile) {
        int cz;
        int cx;
        PredefinedCity.PredefinedBuilding predefinedBuilding = City.getPredefinedBuilding(chunkX, chunkZ, provider);
        if (predefinedBuilding != null) {
            return 1.0f;
        }
        PredefinedCity.PredefinedStreet predefinedStreet = City.getPredefinedStreet(chunkX, chunkZ, provider);
        if (predefinedStreet != null) {
            return 1.0f;
        }
        predefinedBuilding = City.getPredefinedBuilding(chunkX - 1, chunkZ, provider);
        if (predefinedBuilding != null && predefinedBuilding.isMulti()) {
            return 1.0f;
        }
        predefinedBuilding = City.getPredefinedBuilding(chunkX - 1, chunkZ - 1, provider);
        if (predefinedBuilding != null && predefinedBuilding.isMulti()) {
            return 1.0f;
        }
        predefinedBuilding = City.getPredefinedBuilding(chunkX, chunkZ - 1, provider);
        if (predefinedBuilding != null && predefinedBuilding.isMulti()) {
            return 1.0f;
        }
        for (cx = -4; cx <= 4; ++cx) {
            for (cz = -4; cz <= 4; ++cz) {
                if (!provider.hasMansion(chunkX + cx, chunkZ + cz)) continue;
                return 0.0f;
            }
        }
        for (cx = -2; cx <= 2; ++cx) {
            for (cz = -2; cz <= 2; ++cz) {
                if (!provider.hasOceanMonument(chunkX + cx, chunkZ + cz)) continue;
                return 0.0f;
            }
        }
        float factor = 0.0f;
        int offset = (profile.CITY_MAXRADIUS + 15) / 16;
        for (int cx2 = chunkX - offset; cx2 <= chunkX + offset; ++cx2) {
            for (int cz2 = chunkZ - offset; cz2 <= chunkZ + offset; ++cz2) {
                float radius;
                float sqdist;
                LostCityProfile pro = BuildingInfo.getProfile(cx2, cz2, provider);
                if (pro != profile || !City.isCityCenter(cx2, cz2, provider) || !((sqdist = (float)((cx2 * 16 - chunkX * 16) * (cx2 * 16 - chunkX * 16) + (cz2 * 16 - chunkZ * 16) * (cz2 * 16 - chunkZ * 16))) < (radius = City.getCityRadius(cx2, cz2, provider)) * radius)) continue;
                float dist = (float)Math.sqrt(sqdist);
                factor += (radius - dist) / radius;
            }
        }
        float foundFactor = profile.CITY_DEFAULT_BIOME_FACTOR.floatValue();
        Biome[] biomes = BiomeInfo.getBiomeInfo(provider, new ChunkCoord(provider.dimensionId, chunkX, chunkZ)).getBiomes();
        Map<String, Float> map = profile.getBiomeFactorMap();
        for (Biome biome : biomes) {
            Float f;
            ResourceLocation object = (ResourceLocation)Biome.field_185377_q.func_177774_c((Object)biome);
            try {
                f = map.get(object.toString());
            }
            catch (NullPointerException e) {
                throw new RuntimeException("Biome '" + biome.func_185359_l() + "' (" + biome.func_150562_l().getName() + ") could not be found in the biome registry! This is likely a bug in the mod providing that biome!", e);
            }
            if (f == null) continue;
            foundFactor = f.floatValue();
            break;
        }
        return Math.min(Math.max(factor * foundFactor, 0.0f), 1.0f);
    }

    public static boolean isTooHighForBuilding(Biome[] biomes) {
        return false;
    }
}

