/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.laggoggles.tickcentral;

import com.github.terminatornl.laggoggles.tickcentral.EventBusTransformer;
import com.github.terminatornl.laggoggles.tickcentral.RenderManagerTransformer;
import com.github.terminatornl.tickcentral.api.TransformerSupplier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.annotation.Nonnull;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.StringUtils;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;

public class Initializer
implements TransformerSupplier {
    Side side;

    public void onLoad(LaunchClassLoader loader, Side side) {
        this.side = side;
        loader.addTransformerExclusion("com.github.terminatornl.laggoggles.tickcentral.EventBusTransformer");
        loader.addTransformerExclusion("com.github.terminatornl.laggoggles.tickcentral.RenderManagerTransformer");
        loader.addTransformerExclusion("com.github.terminatornl.laggoggles.Main");
    }

    @Nonnull
    public Collection<Class<? extends IClassTransformer>> getLastTransformers() {
        ArrayList<Class<? extends IClassTransformer>> list = new ArrayList<Class<? extends IClassTransformer>>();
        list.add(EventBusTransformer.class);
        if (this.side.isClient()) {
            list.add(RenderManagerTransformer.class);
        }
        return list;
    }

    @Nonnull
    public Collection<String> getTransformers() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(EventBusTransformer.class.getName());
        if (this.side.isClient()) {
            list.add(RenderManagerTransformer.class.getName());
        }
        return list;
    }

    public static void convertTargetInstruction(String targetOwner, String targetName, String targetDesc, String newOwner, String newName, String newDesc, int newOpcode, InsnList instructions) {
        for (AbstractInsnNode node : instructions) {
            switch (node.getOpcode()) {
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    MethodInsnNode methodNode = (MethodInsnNode)node;
                    if (!methodNode.owner.equals(targetOwner) || !methodNode.name.equals(targetName) || !methodNode.desc.equals(targetDesc)) break;
                    methodNode.name = newName;
                    methodNode.owner = newOwner;
                    methodNode.setOpcode(newOpcode);
                    methodNode.desc = newDesc;
                }
            }
        }
    }

    public static void renameTargetInstruction(String targetName, String newName, InsnList instructions) {
        ListIterator iterator = instructions.iterator();
        int count = 0;
        LinkedList<String> checked = new LinkedList<String>();
        while (iterator.hasNext()) {
            AbstractInsnNode node = (AbstractInsnNode)iterator.next();
            switch (node.getOpcode()) {
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    MethodInsnNode methodNode = (MethodInsnNode)node;
                    if (methodNode.name.equals(targetName)) {
                        methodNode.name = newName;
                        ++count;
                        break;
                    }
                    checked.add(methodNode.name + methodNode.desc);
                }
            }
        }
        if (count == 0) {
            throw new IllegalStateException("Did not find target method: " + targetName + ". Checked: " + StringUtils.join(checked, (String)System.lineSeparator()));
        }
    }
}

