package jeresources.util;

import jeresources.api.conditionals.Conditional;
import jeresources.api.conditionals.ICustomLootFunction;
import jeresources.api.drop.LootDrop;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.storage.loot.functions.*;

public class LootFunctionHelper {
    public static void applyFunction(LootFunction lootFunction, LootDrop lootDrop) {
        if (lootFunction instanceof SetCount) {
            lootDrop.minDrop = MathHelper.func_76141_d(((SetCount) lootFunction).field_186568_a.func_186509_a());
            if (lootDrop.minDrop < 0) lootDrop.minDrop = 0;
            lootDrop.item.func_190920_e(lootDrop.minDrop < 1 ? 1 : lootDrop.minDrop);
            lootDrop.maxDrop = MathHelper.func_76141_d(((SetCount) lootFunction).field_186568_a.func_186512_b());
        } else if (lootFunction instanceof SetMetadata) {
            lootDrop.item.func_77964_b(MathHelper.func_76141_d(((SetMetadata) lootFunction).field_186573_b.func_186509_a()));
        } else if (lootFunction instanceof EnchantRandomly || lootFunction instanceof EnchantWithLevels) {
            lootDrop.enchanted = true;
        } else if (lootFunction instanceof Smelt) {
            lootDrop.smeltedItem = lootFunction.func_186553_a(lootDrop.item, null, null);
            if (ItemStack.func_77989_b(lootDrop.item, lootDrop.smeltedItem))
                lootDrop.smeltedItem = null;
        } else if (lootFunction instanceof LootingEnchantBonus) {
            lootDrop.addConditional(Conditional.affectedByLooting);
        } else if (lootFunction instanceof ICustomLootFunction) {
            ((ICustomLootFunction) lootFunction).apply(lootDrop);
        } else {
            try {
                lootDrop.item = lootFunction.func_186553_a(lootDrop.item, null, null);
            } catch (NullPointerException ignored) {
            }
        }
    }
}
