/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.justenoughdimensions.world.gen;

import fi.dy.masa.justenoughdimensions.JustEnoughDimensions;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.ChunkGeneratorFlat;
import net.minecraft.world.gen.FlatGeneratorInfo;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraft.world.gen.MapGenRavine;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.structure.MapGenNetherBridge;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraft.world.gen.structure.StructureOceanMonument;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class ChunkGeneratorFlatJED
extends ChunkGeneratorFlat {
    protected final World field_73163_a;
    protected final Random field_73161_b;
    protected final MapGenCaves caveGenerator = new MapGenCaves();
    protected final MapGenRavine ravineGenerator = new MapGenRavine();
    protected IBlockState[] field_82700_c;
    protected Map<String, MapGenStructure> field_82696_f;
    protected WorldGenLakes field_82703_i;
    protected WorldGenLakes field_82701_j;
    protected boolean field_82697_g;
    protected boolean field_82702_h;
    protected boolean generateCaves;
    protected boolean generateRavine;
    protected boolean doModPopulation;

    public ChunkGeneratorFlatJED(World worldIn, long seed, boolean generateStructures, String flatGeneratorSettings) {
        super(worldIn, seed, generateStructures, flatGeneratorSettings);
        this.field_73163_a = worldIn;
        this.field_73161_b = new Random(seed);
        try {
            FlatGeneratorInfo flatWorldGenInfo = (FlatGeneratorInfo)ObfuscationReflectionHelper.findField(ChunkGeneratorFlat.class, (String)"field_82699_e").get((Object)this);
            Map map = flatWorldGenInfo.func_82644_b();
            this.field_82700_c = (IBlockState[])ObfuscationReflectionHelper.findField(ChunkGeneratorFlat.class, (String)"field_82700_c").get((Object)this);
            this.field_82696_f = (Map)ObfuscationReflectionHelper.findField(ChunkGeneratorFlat.class, (String)"field_82696_f").get((Object)this);
            this.field_82703_i = (WorldGenLakes)ObfuscationReflectionHelper.findField(ChunkGeneratorFlat.class, (String)"field_82703_i").get((Object)this);
            this.field_82701_j = (WorldGenLakes)ObfuscationReflectionHelper.findField(ChunkGeneratorFlat.class, (String)"field_82701_j").get((Object)this);
            this.field_82697_g = ObfuscationReflectionHelper.findField(ChunkGeneratorFlat.class, (String)"field_82697_g").getBoolean((Object)this);
            this.field_82702_h = ObfuscationReflectionHelper.findField(ChunkGeneratorFlat.class, (String)"field_82702_h").getBoolean((Object)this);
            if (map.containsKey("netherfortress")) {
                this.field_82696_f.put("Fortress", (MapGenStructure)((MapGenNetherBridge)TerrainGen.getModdedMapGen((MapGenBase)new MapGenNetherBridge(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.NETHER_BRIDGE)));
            }
            this.generateCaves = map.containsKey("caves");
            this.generateRavine = map.containsKey("ravine");
            this.doModPopulation = !map.containsKey("no_mod_population");
        }
        catch (Exception e) {
            JustEnoughDimensions.logger.error("Failed to reflect fields from {}", (Object)ChunkGeneratorFlat.class.getName(), (Object)e);
        }
    }

    public Chunk func_185932_a(int x, int z) {
        ChunkPrimer chunkPrimer = new ChunkPrimer();
        for (int y = 0; y < this.field_82700_c.length; ++y) {
            IBlockState iBlockState = this.field_82700_c[y];
            if (iBlockState == null) continue;
            for (int tmpX = 0; tmpX < 16; ++tmpX) {
                for (int tmpZ = 0; tmpZ < 16; ++tmpZ) {
                    chunkPrimer.func_177855_a(tmpX, y, tmpZ, iBlockState);
                }
            }
        }
        if (this.generateCaves) {
            this.caveGenerator.func_186125_a(this.field_73163_a, x, z, chunkPrimer);
        }
        if (this.generateRavine) {
            this.ravineGenerator.func_186125_a(this.field_73163_a, x, z, chunkPrimer);
        }
        for (MapGenBase mapGenBase : this.field_82696_f.values()) {
            mapGenBase.func_186125_a(this.field_73163_a, x, z, chunkPrimer);
        }
        Chunk chunk = new Chunk(this.field_73163_a, chunkPrimer, x, z);
        Biome[] biomeArray = this.field_73163_a.func_72959_q().func_76933_b((Biome[])null, x * 16, z * 16, 16, 16);
        byte[] biomeByteArray = chunk.func_76605_m();
        for (int i = 0; i < biomeByteArray.length; ++i) {
            biomeByteArray[i] = (byte)Biome.func_185362_a((Biome)biomeArray[i]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        BlockPos pos;
        BlockFalling.field_149832_M = true;
        ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
        int startX = chunkX * 16;
        int startZ = chunkZ * 16;
        BlockPos startCorner = new BlockPos(startX, 0, startZ);
        Biome biome = this.field_73163_a.func_180494_b(new BlockPos(startX + 16, 0, startZ + 16));
        boolean villageGenerated = false;
        this.field_73161_b.setSeed(this.field_73163_a.func_72905_C());
        long k = this.field_73161_b.nextLong() / 2L * 2L + 1L;
        long l = this.field_73161_b.nextLong() / 2L * 2L + 1L;
        this.field_73161_b.setSeed((long)chunkX * k + (long)chunkZ * l ^ this.field_73163_a.func_72905_C());
        if (this.doModPopulation) {
            ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.field_73163_a, (Random)this.field_73161_b, (int)chunkX, (int)chunkZ, (boolean)villageGenerated);
        }
        for (MapGenStructure structure : this.field_82696_f.values()) {
            boolean success = structure.func_175794_a(this.field_73163_a, this.field_73161_b, chunkPos);
            if (!(structure instanceof MapGenVillage)) continue;
            villageGenerated |= success;
        }
        if (this.field_82703_i != null && !villageGenerated && this.field_73161_b.nextInt(4) == 0) {
            this.field_82703_i.func_180709_b(this.field_73163_a, this.field_73161_b, startCorner.func_177982_a(this.field_73161_b.nextInt(16) + 8, this.field_73161_b.nextInt(256), this.field_73161_b.nextInt(16) + 8));
        }
        if (!(this.field_82701_j == null || villageGenerated || this.field_73161_b.nextInt(8) != 0 || (pos = startCorner.func_177982_a(this.field_73161_b.nextInt(16) + 8, this.field_73161_b.nextInt(this.field_73161_b.nextInt(248) + 8), this.field_73161_b.nextInt(16) + 8)).func_177956_o() >= this.field_73163_a.func_181545_F() && this.field_73161_b.nextInt(10) != 0)) {
            this.field_82701_j.func_180709_b(this.field_73163_a, this.field_73161_b, pos);
        }
        if (this.field_82702_h) {
            for (int i = 0; i < 8; ++i) {
                new WorldGenDungeons().func_180709_b(this.field_73163_a, this.field_73161_b, startCorner.func_177982_a(this.field_73161_b.nextInt(16) + 8, this.field_73161_b.nextInt(256), this.field_73161_b.nextInt(16) + 8));
            }
        }
        if (this.field_82697_g) {
            biome.func_180624_a(this.field_73163_a, this.field_73161_b, startCorner);
        }
        if (this.doModPopulation) {
            ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.field_73163_a, (Random)this.field_73161_b, (int)chunkX, (int)chunkZ, (boolean)villageGenerated);
        }
        BlockFalling.field_149832_M = false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        if (creatureType == EnumCreatureType.MONSTER) {
            for (MapGenStructure gen : this.field_82696_f.values()) {
                if (gen instanceof MapGenNetherBridge) {
                    if (gen.func_175795_b(pos)) {
                        return ((MapGenNetherBridge)gen).func_75059_a();
                    }
                    if (this.field_73163_a.func_180495_p(pos.func_177977_b()).func_177230_c() != Blocks.field_150385_bj || !gen.func_175796_a(this.field_73163_a, pos)) continue;
                    return ((MapGenNetherBridge)gen).func_75059_a();
                }
                if (gen instanceof MapGenScatteredFeature) {
                    if (!((MapGenScatteredFeature)gen).func_175798_a(pos)) continue;
                    return ((MapGenScatteredFeature)gen).func_82667_a();
                }
                if (!(gen instanceof StructureOceanMonument) || !((StructureOceanMonument)gen).func_175796_a(this.field_73163_a, pos)) continue;
                return ((StructureOceanMonument)gen).func_175799_b();
            }
        }
        return super.func_177458_a(creatureType, pos);
    }
}

