/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mp4.demuxer;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.jcodec.common.io.SeekableByteChannel;
import org.jcodec.common.model.Packet;
import org.jcodec.containers.mp4.MP4Packet;
import org.jcodec.containers.mp4.QTTimeUtil;
import org.jcodec.containers.mp4.boxes.Box;
import org.jcodec.containers.mp4.boxes.CompositionOffsetsBox;
import org.jcodec.containers.mp4.boxes.MovieBox;
import org.jcodec.containers.mp4.boxes.NodeBox;
import org.jcodec.containers.mp4.boxes.SampleSizesBox;
import org.jcodec.containers.mp4.boxes.SyncSamplesBox;
import org.jcodec.containers.mp4.boxes.TrakBox;
import org.jcodec.containers.mp4.demuxer.AbstractMP4DemuxerTrack;

public class MP4DemuxerTrack
extends AbstractMP4DemuxerTrack {
    private int[] sizes;
    private long offInChunk;
    private int noInChunk;
    private int[] syncSamples;
    private int[] partialSync;
    private int ssOff;
    private int psOff;
    private CompositionOffsetsBox.Entry[] compOffsets;
    private int cttsInd;
    private int cttsSubInd;
    private SeekableByteChannel input;
    private MovieBox movie;

    public MP4DemuxerTrack(MovieBox mov, TrakBox trak, SeekableByteChannel input) {
        super(trak);
        this.input = input;
        this.movie = mov;
        SampleSizesBox stsz = NodeBox.findFirstPath(trak, SampleSizesBox.class, Box.path("mdia.minf.stbl.stsz"));
        SyncSamplesBox stss = NodeBox.findFirstPath(trak, SyncSamplesBox.class, Box.path("mdia.minf.stbl.stss"));
        SyncSamplesBox stps = NodeBox.findFirstPath(trak, SyncSamplesBox.class, Box.path("mdia.minf.stbl.stps"));
        CompositionOffsetsBox ctts = NodeBox.findFirstPath(trak, CompositionOffsetsBox.class, Box.path("mdia.minf.stbl.ctts"));
        CompositionOffsetsBox.Entry[] entryArray = this.compOffsets = ctts == null ? null : ctts.getEntries();
        if (stss != null) {
            this.syncSamples = stss.getSyncSamples();
        }
        if (stps != null) {
            this.partialSync = stps.getSyncSamples();
        }
        this.sizes = stsz.getSizes();
    }

    @Override
    public synchronized MP4Packet nextFrame() throws IOException {
        if (this.curFrame >= (long)this.sizes.length) {
            return null;
        }
        int size = this.sizes[(int)this.curFrame];
        return this.getNextFrame(ByteBuffer.allocate(size));
    }

    @Override
    public synchronized MP4Packet getNextFrame(ByteBuffer storage) throws IOException {
        boolean sync;
        if (this.curFrame >= (long)this.sizes.length) {
            return null;
        }
        int size = this.sizes[(int)this.curFrame];
        if (storage != null && storage.remaining() < size) {
            throw new IllegalArgumentException("Buffer size is not enough to fit a packet");
        }
        long pktPos = this.chunkOffsets[Math.min(this.chunkOffsets.length - 1, this.stcoInd)] + this.offInChunk;
        ByteBuffer result = this.readPacketData(this.input, storage, pktPos, size);
        if (result != null && result.remaining() < size) {
            return null;
        }
        int duration = this.timeToSamples[this.sttsInd].getSampleDuration();
        boolean bl = sync = this.syncSamples == null;
        if (this.syncSamples != null && this.ssOff < this.syncSamples.length && this.curFrame + 1L == (long)this.syncSamples[this.ssOff]) {
            sync = true;
            ++this.ssOff;
        }
        boolean psync = false;
        if (this.partialSync != null && this.psOff < this.partialSync.length && this.curFrame + 1L == (long)this.partialSync[this.psOff]) {
            psync = true;
            ++this.psOff;
        }
        long realPts = this.pts;
        if (this.compOffsets != null) {
            realPts = this.pts + (long)this.compOffsets[this.cttsInd].getOffset();
            ++this.cttsSubInd;
            if (this.cttsInd < this.compOffsets.length - 1 && this.cttsSubInd == this.compOffsets[this.cttsInd].getCount()) {
                ++this.cttsInd;
                this.cttsSubInd = 0;
            }
        }
        ByteBuffer data = result == null ? null : this.convertPacket(result);
        long _pts = QTTimeUtil.mediaToEdited(this.box, realPts, this.movie.getTimescale());
        Packet.FrameType ftype = sync ? Packet.FrameType.KEY : Packet.FrameType.INTER;
        int entryNo = this.sampleToChunks[this.stscInd].getEntry() - 1;
        MP4Packet pkt = new MP4Packet(data, _pts, this.timescale, duration, this.curFrame, ftype, null, 0, realPts, entryNo, pktPos, size, psync);
        this.offInChunk += (long)size;
        ++this.curFrame;
        ++this.noInChunk;
        if (this.noInChunk >= this.sampleToChunks[this.stscInd].getCount()) {
            this.noInChunk = 0;
            this.offInChunk = 0L;
            this.nextChunk();
        }
        this.shiftPts(1L);
        return pkt;
    }

    @Override
    public boolean gotoSyncFrame(long frameNo) {
        if (this.syncSamples == null) {
            return this.gotoFrame(frameNo);
        }
        if (frameNo < 0L) {
            throw new IllegalArgumentException("negative frame number");
        }
        if (frameNo >= this.getFrameCount()) {
            return false;
        }
        if (frameNo == this.curFrame) {
            return true;
        }
        for (int i = 0; i < this.syncSamples.length; ++i) {
            if ((long)(this.syncSamples[i] - 1) <= frameNo) continue;
            return this.gotoFrame(this.syncSamples[i - 1] - 1);
        }
        return this.gotoFrame(this.syncSamples[this.syncSamples.length - 1] - 1);
    }

    @Override
    protected void seekPointer(long frameNo) {
        if (this.compOffsets != null) {
            this.cttsSubInd = (int)frameNo;
            this.cttsInd = 0;
            while (this.cttsSubInd >= this.compOffsets[this.cttsInd].getCount()) {
                this.cttsSubInd -= this.compOffsets[this.cttsInd].getCount();
                ++this.cttsInd;
            }
        }
        this.curFrame = (int)frameNo;
        this.stcoInd = 0;
        this.stscInd = 0;
        this.noInChunk = (int)frameNo;
        this.offInChunk = 0L;
        while (this.noInChunk >= this.sampleToChunks[this.stscInd].getCount()) {
            this.noInChunk -= this.sampleToChunks[this.stscInd].getCount();
            this.nextChunk();
        }
        for (int i = 0; i < this.noInChunk; ++i) {
            this.offInChunk += (long)this.sizes[(int)frameNo - this.noInChunk + i];
        }
        if (this.syncSamples != null) {
            this.ssOff = 0;
            while (this.ssOff < this.syncSamples.length && (long)this.syncSamples[this.ssOff] < this.curFrame + 1L) {
                ++this.ssOff;
            }
        }
        if (this.partialSync != null) {
            this.psOff = 0;
            while (this.psOff < this.partialSync.length && (long)this.partialSync[this.psOff] < this.curFrame + 1L) {
                ++this.psOff;
            }
        }
    }

    @Override
    public long getFrameCount() {
        return this.sizes.length;
    }
}

