/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.rules;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import mcjty.incontrol.InControl;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class RuleCache {
    private Map<Integer, CachePerWorld> caches = new HashMap<Integer, CachePerWorld>();

    public void reset(World world) {
        CachePerWorld cache = this.caches.get(world.field_73011_w.getDimension());
        if (cache != null) {
            cache.reset();
        }
    }

    public int getValidSpawnChunks(World world) {
        CachePerWorld cache = this.getOrCreateCache(world);
        return cache.getValidSpawnChunks(world);
    }

    public int getValidPlayers(World world) {
        CachePerWorld cache = this.getOrCreateCache(world);
        return cache.getValidPlayers(world);
    }

    public int getCountPassive(World world) {
        CachePerWorld cache = this.getOrCreateCache(world);
        return cache.getCountPassive(world);
    }

    public int getCountHostile(World world) {
        CachePerWorld cache = this.getOrCreateCache(world);
        return cache.getCountHostile(world);
    }

    public int getCount(World world, Class<? extends Entity> entityType) {
        CachePerWorld cache = this.getOrCreateCache(world);
        int count = cache.getCount(world, entityType);
        return count;
    }

    public int getCountPerMod(World world, String mod) {
        CachePerWorld cache = this.getOrCreateCache(world);
        CountPerMod countPerMod = cache.getCountPerMod(world, mod);
        return countPerMod == null ? 0 : countPerMod.total;
    }

    public int getCountPerModHostile(World world, String mod) {
        CachePerWorld cache = this.getOrCreateCache(world);
        CountPerMod countPerMod = cache.getCountPerMod(world, mod);
        return countPerMod == null ? 0 : countPerMod.hostile;
    }

    public int getCountPerModPassive(World world, String mod) {
        CachePerWorld cache = this.getOrCreateCache(world);
        CountPerMod countPerMod = cache.getCountPerMod(world, mod);
        return countPerMod == null ? 0 : countPerMod.passive;
    }

    public void registerSpawn(World world, Class<? extends Entity> entityType) {
        CachePerWorld cache = this.getOrCreateCache(world);
        cache.registerSpawn(world, entityType);
    }

    public void registerDespawn(World world, Class<? extends Entity> entityType) {
        CachePerWorld cache = this.getOrCreateCache(world);
        cache.registerDespawn(world, entityType);
    }

    private CachePerWorld getOrCreateCache(World world) {
        CachePerWorld cache = this.caches.get(world.field_73011_w.getDimension());
        if (cache == null) {
            cache = new CachePerWorld();
            this.caches.put(world.field_73011_w.getDimension(), cache);
        }
        return cache;
    }

    private class CachePerWorld {
        private Map<Class, Integer> cachedCounters = new HashMap<Class, Integer>();
        private Map<String, CountPerMod> countPerMod = new HashMap<String, CountPerMod>();
        private int countPassive = -1;
        private int countHostile = -1;
        private int validSpawnChunks = -1;
        private int validPlayers = -1;
        private boolean countDone = false;

        private CachePerWorld() {
        }

        public void reset() {
            this.cachedCounters.clear();
            this.countPerMod.clear();
            this.countPassive = -1;
            this.countHostile = -1;
            this.validSpawnChunks = -1;
            this.validPlayers = -1;
            this.countDone = false;
        }

        public int getValidSpawnChunks(World world) {
            if (this.validSpawnChunks == -1) {
                this.validSpawnChunks = this.countValidSpawnChunks((WorldServer)world);
            }
            return this.validSpawnChunks;
        }

        public int getValidPlayers(World world) {
            if (this.validPlayers == -1) {
                this.validPlayers = this.countValidPlayers(world);
            }
            return this.validPlayers;
        }

        private int countValidPlayers(World world) {
            int cnt = 0;
            for (EntityPlayer entityplayer : world.field_73010_i) {
                if (entityplayer.func_175149_v()) continue;
                ++cnt;
            }
            return cnt;
        }

        private int countValidSpawnChunks(WorldServer world) {
            HashSet<ChunkPos> eligibleChunksForSpawning = new HashSet<ChunkPos>();
            for (EntityPlayer entityplayer : world.field_73010_i) {
                if (entityplayer.func_175149_v()) continue;
                int chunkX = MathHelper.func_76128_c((double)(entityplayer.field_70165_t / 16.0));
                int chunkZ = MathHelper.func_76128_c((double)(entityplayer.field_70161_v / 16.0));
                for (int dx = -8; dx <= 8; ++dx) {
                    for (int dz = -8; dz <= 8; ++dz) {
                        PlayerChunkMapEntry entry;
                        boolean flag = dx == -8 || dx == 8 || dz == -8 || dz == 8;
                        ChunkPos chunkpos = new ChunkPos(dx + chunkX, dz + chunkZ);
                        if (eligibleChunksForSpawning.contains(chunkpos) || flag || !world.func_175723_af().func_177730_a(chunkpos) || (entry = world.func_184164_w().func_187301_b(chunkpos.field_77276_a, chunkpos.field_77275_b)) == null || !entry.func_187274_e()) continue;
                        eligibleChunksForSpawning.add(chunkpos);
                    }
                }
            }
            return eligibleChunksForSpawning.size();
        }

        public int getCountPassive(World world) {
            this.count(world);
            return this.countPassive;
        }

        public int getCountHostile(World world) {
            this.count(world);
            return this.countHostile;
        }

        private void count(World world) {
            if (this.countDone) {
                return;
            }
            this.countDone = true;
            this.cachedCounters.clear();
            this.countPerMod.clear();
            this.countPassive = 0;
            this.countHostile = 0;
            for (Entity entity : world.field_72996_f) {
                if (!(entity instanceof EntityLiving)) continue;
                int cnt = this.cachedCounters.getOrDefault(entity.getClass(), 0) + 1;
                this.cachedCounters.put(entity.getClass(), cnt);
                String mod = InControl.instance.modCache.getMod(entity);
                CountPerMod count = this.countPerMod.computeIfAbsent(mod, s -> new CountPerMod());
                count.total++;
                if (entity instanceof IMob) {
                    count.hostile++;
                    ++this.countHostile;
                    continue;
                }
                if (!(entity instanceof IAnimals)) continue;
                count.passive++;
                ++this.countPassive;
            }
        }

        public int getCount(World world, Class<? extends Entity> entityType) {
            this.count(world);
            return this.cachedCounters.getOrDefault(entityType, 0);
        }

        public CountPerMod getCountPerMod(World world, String mod) {
            this.count(world);
            return this.countPerMod.get(mod);
        }

        public void registerSpawn(World world, Class<? extends Entity> entityType) {
            this.count(world);
            this.cachedCounters.put(entityType, this.cachedCounters.getOrDefault(entityType, 0) + 1);
        }

        public void registerDespawn(World world, Class<? extends Entity> entityType) {
            this.count(world);
            Integer cnt = this.cachedCounters.getOrDefault(entityType, 0);
            if (cnt > 0) {
                this.cachedCounters.put(entityType, cnt - 1);
            }
        }
    }

    private static class CountPerMod {
        private int hostile;
        private int passive;
        private int total;

        private CountPerMod() {
        }
    }
}

