/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.huntingdim.handler;

import net.darkhax.bookshelf.lib.Constants;
import net.darkhax.bookshelf.util.MathsUtils;
import net.darkhax.bookshelf.util.WorldUtils;
import net.darkhax.huntingdim.HuntingDimension;
import net.darkhax.huntingdim.events.EventLoader;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class SeasonalEvents {
    @SubscribeEvent
    public void onLivingSpawn(LivingSpawnEvent.SpecialSpawn event) {
        if (this.isValidWorld(event.getWorld()) && this.isValidMob(event.getEntityLiving()) && MathsUtils.tryPercentage((double)0.1)) {
            if (Constants.RANDOM.nextBoolean()) {
                ItemStack head = EventLoader.currentEvent.getRandomWorn().func_77946_l();
                event.getEntityLiving().func_184201_a(EntityEquipmentSlot.HEAD, head);
            } else {
                ItemStack hand = EventLoader.currentEvent.getRandomHeld().func_77946_l();
                event.getEntityLiving().func_184201_a(EntityEquipmentSlot.MAINHAND, hand);
            }
        }
    }

    private boolean isValidWorld(World world) {
        return WorldUtils.isDimension((World)world, (DimensionType)HuntingDimension.dimensionType) && !world.field_72995_K;
    }

    private boolean isValidMob(EntityLivingBase entity) {
        return entity instanceof EntityZombie || entity instanceof EntitySkeleton;
    }
}

