/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.huntingdim.events;

import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Calendar;
import net.darkhax.huntingdim.HuntingDimension;
import net.darkhax.huntingdim.events.EventData;
import net.darkhax.huntingdim.handler.SeasonalEvents;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;

public class EventLoader {
    public static EventData currentEvent;
    public static int month;
    public static int day;
    public static int year;

    public static void loadCurrentEvents() {
        Calendar cal = Calendar.getInstance();
        month = cal.get(2) + 1;
        day = cal.get(5);
        year = cal.get(1);
        EventLoader.loadEvent("halloween", 10, 20, 10, 31);
        if (currentEvent != null) {
            HuntingDimension.LOG.info("Current event is {}.", new Object[]{currentEvent.getName()});
            MinecraftForge.EVENT_BUS.register((Object)new SeasonalEvents());
        }
    }

    private static void loadEvent(String name, int startMonth, int startDay, int endMonth, int endDay) {
        if (!EventLoader.isCurrent(startMonth, startDay, endMonth, endDay)) {
            return;
        }
        try (InputStream stream = HuntingDimension.class.getResourceAsStream("/assets/huntingdim/events/" + name + ".dat");
             DataInputStream data = new DataInputStream(stream);){
            NBTTagCompound tag = CompressedStreamTools.func_74794_a((DataInputStream)data);
            currentEvent = new EventData(tag);
        }
        catch (Exception e) {
            HuntingDimension.LOG.error("Unabled to read event data for {}.", new Object[]{name});
            HuntingDimension.LOG.catching((Throwable)e);
        }
    }

    private static boolean isCurrent(int startMonth, int startDay, int endMonth, int endDay) {
        return startMonth <= month && endMonth >= month && startDay <= day && endDay >= day;
    }
}

