/*
 * Decompiled with CFR 0.152.
 */
package elec332.huds.client.hud.damage;

import elec332.core.client.RenderHelper;
import elec332.core.client.util.GuiDraw;
import elec332.core.hud.AbstractHud;
import elec332.core.hud.drawing.EntityDrawer;
import elec332.core.hud.drawing.IDrawer;
import elec332.core.hud.position.Alignment;
import elec332.core.hud.position.HorizontalStartingPoint;
import elec332.core.hud.position.IStartingPoint;
import elec332.core.hud.position.VerticalStartingPoint;
import java.awt.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DamageHud
extends AbstractHud {
    @Nullable
    private EntityLivingBase entity;
    private int noSelectTime;
    private int noSelTimeConf = 200;
    private int deathShowConf = 20;
    private static final IDrawer<Entity> hudEntityDrawer = new EntityDrawer(25.0f, 33.0f, 15.0f);
    private static final ResourceLocation hud = new ResourceLocation("eleccore", "mobhudbackbgound.png");

    public DamageHud() {
        super(Alignment.LEFT, (IStartingPoint)HorizontalStartingPoint.LEFT, (IStartingPoint)VerticalStartingPoint.TOP);
    }

    public int getHudHeight() {
        return 50;
    }

    protected void configure(@Nonnull Configuration config) {
        this.noSelTimeConf = config.getInt("noSelectTime", this.getConfigCategory(), this.noSelTimeConf, 0, 1000, "The time to show the mob-hud whilst not hovering over it anymore. (In ticks, 1/20th of a second)");
        this.deathShowConf = config.getInt("timeShowDeath", this.getConfigCategory(), this.deathShowConf, 0, 1000, "The time to show the mob-hud of an entity whilst it's dead. (In ticks, 1/20th of a second)");
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        Entity entity = GuiDraw.mc.func_175598_ae().field_147941_i;
        if (this.entity != null && this.entity.field_70128_L && this.noSelectTime < this.noSelTimeConf - this.deathShowConf) {
            this.noSelectTime = this.noSelTimeConf - this.deathShowConf;
        }
        if (entity != null && entity instanceof EntityLivingBase) {
            if (this.entity == null || this.entity.func_145782_y() != entity.func_145782_y()) {
                this.entity = (EntityLivingBase)entity;
                this.noSelectTime = 0;
            }
        } else if (this.entity != null) {
            ++this.noSelectTime;
            if (this.noSelectTime >= this.noSelTimeConf) {
                this.entity = null;
                this.noSelectTime = 0;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHud(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull Alignment alignment, int startX, int startY, float partialTicks) {
        if (this.entity != null) {
            RenderHelper.bindTexture((ResourceLocation)hud);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiDraw.drawScaledCustomSizeModalRect((int)startX, (int)startY, (float)0.0f, (float)0.0f, (int)120, (int)120, (int)40, (int)40, (float)350.0f, (float)128.0f);
            GuiDraw.drawScaledCustomSizeModalRect((int)(startX + 43), (int)startY, (float)120.0f, (float)0.0f, (int)240, (int)75, (int)80, (int)25, (float)350.0f, (float)128.0f);
            int s = 125;
            int e = 345;
            float scale = this.entity.func_110143_aJ() / this.entity.func_110138_aP();
            GuiDraw.drawScaledCustomSizeModalRect((int)(startX + 43 + 1), (int)(startY + 12), (float)s, (float)76.0f, (int)((int)((float)(e - s) * scale)), (int)37, (int)((int)((float)(e - s + 2) * scale / 3.0f)), (int)10, (float)350.0f, (float)128.0f);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(startX + 82), (float)(startY + 4), (float)0.0f);
            GlStateManager.func_179152_a((float)0.65f, (float)0.65f, (float)0.65f);
            FontRenderer font = RenderHelper.getMCFontrenderer();
            String txt = this.entity.func_70005_c_();
            if (this.entity.func_70631_g_() && !this.entity.func_145818_k_()) {
                txt = "Baby " + txt;
            }
            font.func_78276_b(txt, -(font.func_78256_a(txt) / 2), 0, Color.WHITE.getRGB());
            txt = (int)this.entity.func_110143_aJ() + "/" + (int)this.entity.func_110138_aP();
            font.func_78276_b(txt, -(font.func_78256_a(txt) / 2), 17, Color.WHITE.getRGB());
            GlStateManager.func_179121_F();
            float entS = 1.0f;
            if (this.entity.field_70131_O > 2.0f) {
                entS = this.entity.field_70131_O / 2.0f;
            }
            if (this.entity.field_70130_N > 1.5f) {
                entS = Math.max(entS, this.entity.field_70130_N / 1.5f);
            }
            int i = 0xF000F0;
            int j = i % 65536;
            int k = i / 65536;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            alignment.renderHudPart(hudEntityDrawer, (Object)this.entity, startX, startY, new Object[]{Float.valueOf(player.field_70177_z + 180.0f), Float.valueOf(entS)});
        }
    }
}

