/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.tile.tooltip.own;

import com.zeitheron.hammercore.tile.tooltip.own.GuiTooltip;
import com.zeitheron.hammercore.tile.tooltip.own.ITooltipProviderHC;
import com.zeitheron.hammercore.utils.WorldLocation;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class EntityTooltipRenderEngine {
    public BlockPos lastPos;
    public UUID lastEntity;
    public GuiTooltip lastTooltip;

    public EntityTooltipRenderEngine() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void renderWorldLast(RenderGameOverlayEvent.Post e) {
        if (e.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            RayTraceResult res = Minecraft.func_71410_x().field_71476_x;
            if (res != null) {
                ITooltipProviderHC prov = null;
                if (res.field_72313_a == RayTraceResult.Type.BLOCK) {
                    boolean diffPos;
                    WorldClient wc = Minecraft.func_71410_x().field_71441_e;
                    BlockPos bp = res.func_178782_a();
                    Block bl = wc.func_180495_p(bp).func_177230_c();
                    TileEntity tl = wc.func_175625_s(bp);
                    if (tl instanceof ITooltipProviderHC) {
                        prov = (ITooltipProviderHC)tl;
                    } else if (bl instanceof ITooltipProviderHC) {
                        prov = (ITooltipProviderHC)bl;
                    }
                    boolean bl2 = diffPos = !Objects.equals(bp, this.lastPos);
                    if (diffPos) {
                        this.lastPos = bp;
                        this.lastTooltip = null;
                    }
                    if (prov != null && (diffPos || prov.isTooltipDirty())) {
                        prov.setTooltipDirty(false);
                        this.lastTooltip = new GuiTooltip().withLocation(new WorldLocation((World)wc, bp)).withProvider(prov);
                    }
                } else if (res.field_72313_a == RayTraceResult.Type.ENTITY && res.field_72308_g instanceof ITooltipProviderHC) {
                    prov = (ITooltipProviderHC)res.field_72308_g;
                    if (prov != null) {
                        boolean diffEntity;
                        boolean bl = diffEntity = !Objects.equals(res.field_72308_g.func_110124_au(), this.lastEntity);
                        if (diffEntity) {
                            this.lastEntity = res.field_72308_g.func_110124_au();
                            this.lastTooltip = null;
                        }
                        if (diffEntity || prov.isTooltipDirty()) {
                            prov.setTooltipDirty(false);
                            this.lastTooltip = new GuiTooltip().withEntity(res.field_72308_g).withProvider(prov);
                        }
                    }
                } else {
                    this.lastPos = null;
                    this.lastTooltip = null;
                }
            } else {
                this.lastPos = null;
                this.lastTooltip = null;
            }
            if (this.lastTooltip != null) {
                float cx = (float)e.getResolution().func_78327_c() / 2.0f + 12.0f;
                float cy = ((float)e.getResolution().func_78324_d() - (float)this.lastTooltip.getHeight()) / 2.0f + 2.0f;
                float pt = e.getPartialTicks();
                this.lastTooltip.render(cx, cy, pt);
            }
        }
    }
}

